/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.schema.filter.SchemaFilterType;
import org.apache.iotdb.commons.schema.node.role.IMeasurementMNode;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.iotdb.commons.schema.view.LogicalViewSchema;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.SchemaDirCreationFailureException;
import org.apache.iotdb.db.exception.metadata.SchemaQuotaExceededException;
import org.apache.iotdb.db.exception.metadata.SeriesOverflowException;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.common.schematree.ClusterSchemaTree;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.DeviceAttributeUpdater;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.DeviceBlackListConstructor;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.TableDeviceQuerySource;
import org.apache.iotdb.db.queryengine.execution.relational.ColumnTransformerBuilder;
import org.apache.iotdb.db.queryengine.plan.analyze.TypeProvider;
import org.apache.iotdb.db.queryengine.plan.planner.LocalExecutionPlanner;
import org.apache.iotdb.db.queryengine.plan.planner.TableOperatorGenerator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.write.CreateTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.TableDeviceSchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.TableDeviceSchemaCache;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.TableId;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.ConstructTableDevicesBlackListNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.CreateOrUpdateTableDeviceNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.DeleteTableDeviceNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.DeleteTableDevicesInBlackListNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.RollbackTableDevicesBlackListNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.TableAttributeColumnDropNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.TableDeviceAttributeCommitUpdateNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.TableDeviceAttributeUpdateNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.TableNodeLocationAddNode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DeleteDevice;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SymbolReference;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.leaf.LeafColumnTransformer;
import org.apache.iotdb.db.schemaengine.metric.ISchemaRegionMetric;
import org.apache.iotdb.db.schemaengine.metric.SchemaRegionMemMetric;
import org.apache.iotdb.db.schemaengine.rescon.DataNodeSchemaQuotaManager;
import org.apache.iotdb.db.schemaengine.rescon.MemSchemaRegionStatistics;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegionParams;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegionPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.SchemaRegion;
import org.apache.iotdb.db.schemaengine.schemaregion.SchemaRegionPlanVisitor;
import org.apache.iotdb.db.schemaengine.schemaregion.SchemaRegionUtils;
import org.apache.iotdb.db.schemaengine.schemaregion.attribute.DeviceAttributeStore;
import org.apache.iotdb.db.schemaengine.schemaregion.attribute.IDeviceAttributeStore;
import org.apache.iotdb.db.schemaengine.schemaregion.attribute.update.DeviceAttributeCacheUpdater;
import org.apache.iotdb.db.schemaengine.schemaregion.attribute.update.UpdateDetailContainer;
import org.apache.iotdb.db.schemaengine.schemaregion.logfile.FakeCRC32Deserializer;
import org.apache.iotdb.db.schemaengine.schemaregion.logfile.FakeCRC32Serializer;
import org.apache.iotdb.db.schemaengine.schemaregion.logfile.SchemaLogReader;
import org.apache.iotdb.db.schemaengine.schemaregion.logfile.SchemaLogWriter;
import org.apache.iotdb.db.schemaengine.schemaregion.logfile.visitor.SchemaRegionPlanDeserializer;
import org.apache.iotdb.db.schemaengine.schemaregion.logfile.visitor.SchemaRegionPlanSerializer;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.MTreeBelowSGMemoryImpl;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.mnode.IMemMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.mnode.info.TableDeviceInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.req.IShowDevicesPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.read.req.IShowNodesPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.read.req.IShowTimeSeriesPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.IDeviceSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.INodeSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.ITimeSeriesSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.reader.ISchemaReader;
import org.apache.iotdb.db.schemaengine.schemaregion.tag.TagManager;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.filter.FilterContainsVisitor;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.IActivateTemplateInClusterPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.IAutoCreateDeviceMNodePlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.IChangeAliasPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.IChangeTagOffsetPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.ICreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.ICreateTimeSeriesPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.IDeactivateTemplatePlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.IDeleteTimeSeriesPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.IPreDeactivateTemplatePlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.IPreDeleteTimeSeriesPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.IRollbackPreDeactivateTemplatePlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.IRollbackPreDeleteTimeSeriesPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.SchemaRegionWritePlanFactory;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.impl.CreateAlignedTimeSeriesPlanImpl;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.impl.CreateTimeSeriesPlanImpl;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.view.IAlterLogicalViewPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.view.ICreateLogicalViewPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.view.IDeleteLogicalViewPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.view.IPreDeleteLogicalViewPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.view.IRollbackPreDeleteLogicalViewPlan;
import org.apache.iotdb.db.schemaengine.table.DataNodeTableCache;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;
import org.apache.iotdb.db.utils.SchemaUtils;
import org.apache.ratis.util.function.TriConsumer;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.read.common.type.TypeFactory;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SchemaRegion(mode="Memory")
public class SchemaRegionMemoryImpl
implements ISchemaRegion {
    private static final Logger logger = LoggerFactory.getLogger(SchemaRegionMemoryImpl.class);
    protected static IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private boolean isRecovering = true;
    private volatile boolean initialized = false;
    private final String databaseDirPath;
    private final String schemaRegionDirPath;
    private final String databaseFullPath;
    private final SchemaRegionId schemaRegionId;
    private boolean usingMLog = true;
    private SchemaLogWriter<ISchemaRegionPlan> logWriter;
    private final MemSchemaRegionStatistics regionStatistics;
    private final SchemaRegionMemMetric metric;
    private final DataNodeSchemaQuotaManager schemaQuotaManager = DataNodeSchemaQuotaManager.getInstance();
    private MTreeBelowSGMemoryImpl mTree;
    private TagManager tagManager;
    private IDeviceAttributeStore deviceAttributeStore;
    private DeviceAttributeCacheUpdater deviceAttributeCacheUpdater;

    public SchemaRegionMemoryImpl(ISchemaRegionParams schemaRegionParams) throws MetadataException {
        File schemaRegionDir;
        this.databaseFullPath = schemaRegionParams.getDatabase();
        this.schemaRegionId = schemaRegionParams.getSchemaRegionId();
        this.databaseDirPath = config.getSchemaDir() + File.separator + this.databaseFullPath;
        this.schemaRegionDirPath = this.databaseDirPath + File.separator + this.schemaRegionId.getId();
        if (config.getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus") && (schemaRegionDir = new File(this.schemaRegionDirPath)).exists()) {
            FileUtils.deleteFileOrDirectory((File)schemaRegionDir);
        }
        this.regionStatistics = new MemSchemaRegionStatistics(this.schemaRegionId.getId(), schemaRegionParams.getSchemaEngineStatistics());
        this.metric = new SchemaRegionMemMetric(this.regionStatistics, this.databaseFullPath);
        this.init();
    }

    @Override
    public synchronized void init() throws MetadataException {
        if (this.initialized) {
            return;
        }
        if (config.getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus")) {
            long memCost = config.getSchemaRatisConsensusLogAppenderBufferSizeMax();
            if (!SystemInfo.getInstance().addDirectBufferMemoryCost(memCost)) {
                throw new MetadataException("Total allocated memory for direct buffer will be " + (SystemInfo.getInstance().getDirectBufferMemoryCost() + memCost) + ", which is greater than limit mem cost: " + SystemInfo.getInstance().getTotalDirectBufferMemorySizeLimit());
            }
        }
        this.initDir();
        try {
            this.isRecovering = true;
            this.deviceAttributeStore = new DeviceAttributeStore(this.regionStatistics);
            this.deviceAttributeCacheUpdater = new DeviceAttributeCacheUpdater(this.regionStatistics, PathUtils.unQualifyDatabaseName((String)this.databaseFullPath));
            this.tagManager = new TagManager(this.schemaRegionDirPath, this.regionStatistics);
            this.mTree = new MTreeBelowSGMemoryImpl(PartialPath.getQualifiedDatabasePartialPath((String)this.databaseFullPath), this.tagManager::readTags, this.tagManager::readAttributes, this.regionStatistics, this.metric);
            if (!config.getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus")) {
                this.usingMLog = true;
                this.initMLog();
            } else {
                this.usingMLog = false;
            }
            this.isRecovering = false;
        }
        catch (IOException e) {
            logger.error("Cannot recover all schema info from {}, we try to recover as possible as we can", (Object)this.schemaRegionDirPath, (Object)e);
        }
        this.initialized = true;
    }

    private void initDir() throws SchemaDirCreationFailureException {
        File schemaRegionFolder;
        File sgSchemaFolder = SystemFileFactory.INSTANCE.getFile(this.databaseDirPath);
        if (!sgSchemaFolder.exists()) {
            if (sgSchemaFolder.mkdirs()) {
                logger.info("create database schema folder {}", (Object)this.databaseDirPath);
            } else if (!sgSchemaFolder.exists()) {
                logger.error("create database schema folder {} failed.", (Object)this.databaseDirPath);
                throw new SchemaDirCreationFailureException(this.databaseDirPath);
            }
        }
        if (!(schemaRegionFolder = SystemFileFactory.INSTANCE.getFile(this.schemaRegionDirPath)).exists()) {
            if (schemaRegionFolder.mkdirs()) {
                logger.info("create schema region folder {}", (Object)this.schemaRegionDirPath);
            } else if (!schemaRegionFolder.exists()) {
                logger.error("create schema region folder {} failed.", (Object)this.schemaRegionDirPath);
                throw new SchemaDirCreationFailureException(this.schemaRegionDirPath);
            }
        }
    }

    private void initMLog() throws IOException {
        this.initFromLog();
        this.logWriter = new SchemaLogWriter<ISchemaRegionPlan>(this.schemaRegionDirPath, "mlog.bin", new FakeCRC32Serializer<ISchemaRegionPlan>(new SchemaRegionPlanSerializer()), config.getSyncMlogPeriodInMs() == 0L);
    }

    public void writeToMLog(ISchemaRegionPlan schemaRegionPlan) throws MetadataException {
        if (this.usingMLog && !this.isRecovering) {
            try {
                this.logWriter.write(schemaRegionPlan);
            }
            catch (IOException e) {
                throw new MetadataException((Throwable)e);
            }
        }
    }

    @Override
    public void forceMlog() {
        if (!this.initialized) {
            return;
        }
        if (this.usingMLog) {
            try {
                SchemaLogWriter<ISchemaRegionPlan> logWriter = this.logWriter;
                if (logWriter != null) {
                    logWriter.force();
                }
            }
            catch (IOException e) {
                logger.error("Cannot force {} mlog to the schema region", (Object)this.schemaRegionId, (Object)e);
            }
        }
    }

    @Override
    public MemSchemaRegionStatistics getSchemaRegionStatistics() {
        return this.regionStatistics;
    }

    @Override
    public ISchemaRegionMetric getSchemaRegionMetric() {
        return this.metric;
    }

    private int initFromLog() throws IOException {
        File logFile = SystemFileFactory.INSTANCE.getFile(this.schemaRegionDirPath + File.separator + "mlog.bin");
        long time = System.currentTimeMillis();
        if (logFile.exists()) {
            int n;
            SchemaLogReader<ISchemaRegionPlan> mLogReader = new SchemaLogReader<ISchemaRegionPlan>(this.schemaRegionDirPath, "mlog.bin", new FakeCRC32Deserializer<ISchemaRegionPlan>(new SchemaRegionPlanDeserializer()));
            try {
                int idx = this.applyMLog(mLogReader);
                logger.debug("spend {} ms to deserialize {} mtree from mlog.bin", (Object)(System.currentTimeMillis() - time), (Object)this.databaseFullPath);
                n = idx;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        mLogReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IOException("Failed to parse " + this.databaseFullPath + " mlog.bin for err:" + e);
                }
            }
            mLogReader.close();
            return n;
        }
        return 0;
    }

    private int applyMLog(SchemaLogReader<ISchemaRegionPlan> mLogReader) {
        int idx = 0;
        RecoverPlanOperator recoverPlanOperator = new RecoverPlanOperator();
        while (mLogReader.hasNext()) {
            RecoverOperationResult operationResult;
            ISchemaRegionPlan plan;
            try {
                plan = mLogReader.next();
                ++idx;
            }
            catch (Exception e) {
                logger.error("Parse mlog error at lineNumber {} because:", (Object)idx, (Object)e);
                break;
            }
            if (plan == null || !(operationResult = plan.accept(recoverPlanOperator, this)).isFailed()) continue;
            logger.error("Can not operate cmd {} for err:", (Object)plan.getPlanType().name(), (Object)operationResult.getException());
        }
        if (mLogReader.isFileCorrupted()) {
            throw new IllegalStateException("The mlog.bin has been corrupted. Please remove it or fix it, and then restart IoTDB");
        }
        return idx;
    }

    @Override
    public synchronized void clear() {
        try {
            if (this.mTree != null) {
                this.mTree.clear();
            }
            this.regionStatistics.clear();
            if (this.logWriter != null) {
                this.logWriter.close();
                this.logWriter = null;
            }
            this.tagManager.clear();
            this.isRecovering = true;
            this.initialized = false;
        }
        catch (IOException e) {
            logger.error("Cannot close metadata log writer, because:", (Throwable)e);
        }
    }

    @Override
    public String getDatabaseFullPath() {
        return this.databaseFullPath;
    }

    @Override
    public SchemaRegionId getSchemaRegionId() {
        return this.schemaRegionId;
    }

    @Override
    public synchronized void deleteSchemaRegion() throws MetadataException {
        this.clear();
        SchemaRegionUtils.deleteSchemaRegionFolder(this.schemaRegionDirPath, logger);
        if (config.getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus")) {
            SystemInfo.getInstance().decreaseDirectBufferMemoryCost(config.getSchemaRatisConsensusLogAppenderBufferSizeMax());
        }
    }

    @Override
    public synchronized boolean createSnapshot(File snapshotDir) {
        if (!this.initialized) {
            logger.warn("Failed to create snapshot of schemaRegion {}, because the schemaRegion has not been initialized.", (Object)this.schemaRegionId);
            return false;
        }
        logger.info("Start create snapshot of schemaRegion {}", (Object)this.schemaRegionId);
        long startTime = System.currentTimeMillis();
        long snapshotStartTime = System.currentTimeMillis();
        boolean isSuccess = this.mTree.createSnapshot(snapshotDir);
        logger.info("MTree snapshot creation of schemaRegion {} costs {}ms. Status: {}", new Object[]{this.schemaRegionId, System.currentTimeMillis() - snapshotStartTime, isSuccess});
        snapshotStartTime = System.currentTimeMillis();
        boolean currentResult = this.tagManager.createSnapshot(snapshotDir);
        isSuccess = isSuccess && currentResult;
        logger.info("Tag snapshot creation of schemaRegion {} costs {}ms. Status: {}", new Object[]{this.schemaRegionId, System.currentTimeMillis() - snapshotStartTime, currentResult});
        snapshotStartTime = System.currentTimeMillis();
        currentResult = this.deviceAttributeStore.createSnapshot(snapshotDir);
        isSuccess = isSuccess && currentResult;
        logger.info("Device attribute snapshot creation of schemaRegion {} costs {}ms. Status: {}", new Object[]{this.schemaRegionId, System.currentTimeMillis() - snapshotStartTime, currentResult});
        snapshotStartTime = System.currentTimeMillis();
        currentResult = this.deviceAttributeCacheUpdater.createSnapshot(snapshotDir);
        isSuccess = isSuccess && currentResult;
        logger.info("Device attribute remote updater snapshot creation of schemaRegion {} costs {}ms. Status: {}", new Object[]{this.schemaRegionId, System.currentTimeMillis() - snapshotStartTime, currentResult});
        logger.info("Snapshot creation of schemaRegion {} costs {}ms.", (Object)this.schemaRegionId, (Object)(System.currentTimeMillis() - startTime));
        if (isSuccess) {
            logger.info("Successfully create snapshot of schemaRegion {}", (Object)this.schemaRegionId);
        }
        return isSuccess;
    }

    @Override
    public void loadSnapshot(File latestSnapshotRootDir) {
        this.clear();
        logger.info("Start loading snapshot of schemaRegion {}", (Object)this.schemaRegionId);
        long startTime = System.currentTimeMillis();
        try {
            this.usingMLog = false;
            this.isRecovering = true;
            long snapshotStartTime = System.currentTimeMillis();
            this.deviceAttributeStore = new DeviceAttributeStore(this.regionStatistics);
            this.deviceAttributeStore.loadFromSnapshot(latestSnapshotRootDir);
            logger.info("Device attribute snapshot loading of schemaRegion {} costs {}ms.", (Object)this.schemaRegionId, (Object)(System.currentTimeMillis() - snapshotStartTime));
            snapshotStartTime = System.currentTimeMillis();
            this.deviceAttributeCacheUpdater = new DeviceAttributeCacheUpdater(this.regionStatistics, this.databaseFullPath);
            this.deviceAttributeCacheUpdater.loadFromSnapshot(latestSnapshotRootDir);
            logger.info("Device attribute remote updater snapshot loading of schemaRegion {} costs {}ms.", (Object)this.schemaRegionId, (Object)(System.currentTimeMillis() - snapshotStartTime));
            snapshotStartTime = System.currentTimeMillis();
            this.tagManager = TagManager.loadFromSnapshot(latestSnapshotRootDir, this.schemaRegionDirPath, this.regionStatistics);
            logger.info("Tag snapshot loading of schemaRegion {} costs {}ms.", (Object)this.schemaRegionId, (Object)(System.currentTimeMillis() - snapshotStartTime));
            snapshotStartTime = System.currentTimeMillis();
            this.mTree = MTreeBelowSGMemoryImpl.loadFromSnapshot(latestSnapshotRootDir, this.databaseFullPath, this.regionStatistics, this.metric, measurementMNode -> {
                if (measurementMNode.isLogicalView()) {
                    this.regionStatistics.addView(1L);
                } else {
                    this.regionStatistics.addMeasurement(1L);
                }
                if (measurementMNode.getOffset() == -1L) {
                    return;
                }
                try {
                    this.tagManager.recoverIndex(measurementMNode.getOffset(), (IMeasurementMNode<?>)measurementMNode);
                }
                catch (IOException e) {
                    logger.error("Failed to recover tagIndex for {} in schemaRegion {}.", (Object)(this.databaseFullPath + "." + measurementMNode.getFullPath()), (Object)this.schemaRegionId);
                }
            }, deviceMNode -> {
                this.regionStatistics.addDevice();
                if (deviceMNode.getSchemaTemplateIdWithState() >= 0) {
                    this.regionStatistics.activateTemplate(deviceMNode.getSchemaTemplateId());
                }
            }, (tableDeviceMode, tableName) -> {
                this.regionStatistics.addTableDevice((String)tableName);
                this.regionStatistics.addTableAttributeMemory((String)tableName, this.deviceAttributeStore.getAttributes(((TableDeviceInfo)tableDeviceMode.getDeviceInfo()).getAttributePointer()).values().stream().map(UpdateDetailContainer::sizeOf).reduce(0L, Long::sum));
            }, this.tagManager::readTags, this.tagManager::readAttributes);
            logger.info("MTree snapshot loading of schemaRegion {} costs {}ms.", (Object)this.schemaRegionId, (Object)(System.currentTimeMillis() - snapshotStartTime));
            this.isRecovering = false;
            this.initialized = true;
            logger.info("Snapshot loading of schemaRegion {} costs {}ms.", (Object)this.schemaRegionId, (Object)(System.currentTimeMillis() - startTime));
            logger.info("Successfully load snapshot of schemaRegion {}", (Object)this.schemaRegionId);
        }
        catch (Exception e) {
            logger.error("Failed to load snapshot for schemaRegion {}  due to {}. Use empty schemaRegion", new Object[]{this.schemaRegionId, e.getMessage(), e});
            try {
                this.initialized = false;
                this.isRecovering = true;
                this.init();
            }
            catch (Exception exception) {
                logger.error("Error occurred during initializing schemaRegion {}", (Object)this.schemaRegionId, (Object)exception);
            }
        }
    }

    public void createTimeseries(ICreateTimeSeriesPlan plan) throws MetadataException {
        this.createTimeSeries(plan, -1L);
    }

    @Override
    public void createTimeSeries(ICreateTimeSeriesPlan plan, long offset) throws MetadataException {
        if (!this.regionStatistics.isAllowToCreateNewSeries()) {
            throw new SeriesOverflowException(this.regionStatistics.getGlobalMemoryUsage(), this.regionStatistics.getGlobalSeriesNumber());
        }
        try {
            MeasurementPath path = plan.getPath();
            SchemaUtils.checkDataTypeWithEncoding(plan.getDataType(), plan.getEncoding());
            TSDataType type = plan.getDataType();
            IMeasurementMNode<IMemMNode> leafMNode = this.mTree.createTimeSeries((PartialPath)path, type, plan.getEncoding(), plan.getCompressor(), plan.getProps(), plan.getAlias(), plan instanceof CreateTimeSeriesPlanImpl && ((CreateTimeSeriesPlanImpl)plan).isWithMerge() || plan instanceof CreateTimeSeriesNode && ((CreateTimeSeriesNode)plan).isGeneratedByPipe());
            if (Objects.isNull(leafMNode)) {
                this.upsertAliasAndTagsAndAttributes(plan.getAlias(), plan.getTags(), plan.getAttributes(), (PartialPath)path);
                return;
            }
            this.regionStatistics.addMeasurement(1L);
            if (offset != -1L && this.isRecovering) {
                this.tagManager.recoverIndex(offset, leafMNode);
            } else if (plan.getTags() != null) {
                this.tagManager.addIndex(plan.getTags(), leafMNode);
            }
            if (!this.isRecovering) {
                if (plan.getTags() != null && !plan.getTags().isEmpty() || plan.getAttributes() != null && !plan.getAttributes().isEmpty()) {
                    offset = this.tagManager.writeTagFile(plan.getTags(), plan.getAttributes());
                }
                plan.setTagOffset(offset);
                this.writeToMLog(plan);
            }
            if (offset != -1L) {
                leafMNode.setOffset(offset);
            }
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
    }

    @Override
    public void createAlignedTimeSeries(ICreateAlignedTimeSeriesPlan plan) throws MetadataException {
        if (!this.regionStatistics.isAllowToCreateNewSeries()) {
            throw new SeriesOverflowException(this.regionStatistics.getGlobalMemoryUsage(), this.regionStatistics.getGlobalSeriesNumber());
        }
        try {
            int i;
            PartialPath prefixPath = plan.getDevicePath();
            List<String> measurements = plan.getMeasurements();
            List<TSDataType> dataTypes = plan.getDataTypes();
            List<TSEncoding> encodings = plan.getEncodings();
            List<CompressionType> compressors = plan.getCompressors();
            List<String> aliasList = plan.getAliasList();
            List<Map<String, String>> tagsList = plan.getTagsList();
            List<Map<String, String>> attributesList = plan.getAttributesList();
            for (int i2 = 0; i2 < measurements.size(); ++i2) {
                SchemaUtils.checkDataTypeWithEncoding(dataTypes.get(i2), encodings.get(i2));
            }
            HashSet<Integer> existingMeasurementIndexes = new HashSet<Integer>();
            List<IMeasurementMNode<IMemMNode>> measurementMNodeList = this.mTree.createAlignedTimeSeries(prefixPath, measurements, dataTypes, encodings, compressors, aliasList, plan instanceof CreateAlignedTimeSeriesPlanImpl && ((CreateAlignedTimeSeriesPlanImpl)plan).isWithMerge(), existingMeasurementIndexes);
            this.regionStatistics.addMeasurement(measurementMNodeList.size());
            List<Long> tagOffsets = plan.getTagOffsets();
            for (i = measurements.size() - 1; i >= 0 && !existingMeasurementIndexes.isEmpty(); --i) {
                if (!existingMeasurementIndexes.remove(i)) continue;
                this.upsertAliasAndTagsAndAttributes(Objects.nonNull(aliasList) ? aliasList.remove(i) : null, Objects.nonNull(tagsList) ? tagsList.remove(i) : null, Objects.nonNull(attributesList) ? attributesList.remove(i) : null, (PartialPath)prefixPath.concatAsMeasurementPath(measurements.get(i)));
                if (Objects.nonNull(tagOffsets) && !tagOffsets.isEmpty()) {
                    tagOffsets.remove(i);
                }
                measurements.remove(i);
                dataTypes.remove(i);
                encodings.remove(i);
                compressors.remove(i);
            }
            if (measurementMNodeList.isEmpty()) {
                return;
            }
            for (i = 0; i < measurements.size(); ++i) {
                if (tagOffsets != null && !tagOffsets.isEmpty() && this.isRecovering) {
                    if (tagOffsets.get(i) == -1L) continue;
                    this.tagManager.recoverIndex(plan.getTagOffsets().get(i), measurementMNodeList.get(i));
                    continue;
                }
                if (tagsList == null || tagsList.isEmpty() || tagsList.get(i) == null) continue;
                this.tagManager.addIndex(tagsList.get(i), measurementMNodeList.get(i));
            }
            tagOffsets = new ArrayList<Long>();
            if (!this.isRecovering) {
                if (tagsList != null && !tagsList.isEmpty() || attributesList != null && !attributesList.isEmpty()) {
                    for (int i3 = 0; i3 < measurements.size(); ++i3) {
                        Map<String, String> attributes;
                        Map<String, String> tags = tagsList == null ? null : tagsList.get(i3);
                        Map<String, String> map = attributes = attributesList == null ? null : attributesList.get(i3);
                        if (tags == null && attributes == null) {
                            tagOffsets.add(-1L);
                            continue;
                        }
                        tagOffsets.add(this.tagManager.writeTagFile(tags, attributes));
                    }
                } else {
                    for (i = 0; i < measurements.size(); ++i) {
                        tagOffsets.add(-1L);
                    }
                }
                plan.setTagOffsets(tagOffsets);
                this.writeToMLog(plan);
            }
            tagOffsets = plan.getTagOffsets();
            for (i = 0; i < measurements.size(); ++i) {
                if (tagOffsets.get(i) == -1L) continue;
                measurementMNodeList.get(i).setOffset(tagOffsets.get(i).longValue());
            }
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
    }

    @Override
    public Map<Integer, MetadataException> checkMeasurementExistence(PartialPath devicePath, List<String> measurementList, List<String> aliasList) {
        return this.mTree.checkMeasurementExistence(devicePath, measurementList, aliasList);
    }

    @Override
    public void checkSchemaQuota(PartialPath devicePath, int timeSeriesNum) throws SchemaQuotaExceededException {
        if (!this.mTree.checkDeviceNodeExists(devicePath)) {
            this.schemaQuotaManager.check(timeSeriesNum, 1);
        } else {
            this.schemaQuotaManager.check(timeSeriesNum, 0);
        }
    }

    @Override
    public void checkSchemaQuota(String tableName, List<Object[]> deviceIdList) throws SchemaQuotaExceededException {
        int notExistNum = this.mTree.getTableDeviceNotExistNum(tableName, deviceIdList);
        this.schemaQuotaManager.check((long)DataNodeTableCache.getInstance().getTable(this.databaseFullPath, tableName).getFieldNum() * (long)notExistNum, notExistNum);
    }

    @Override
    public Pair<Long, Boolean> constructSchemaBlackList(PathPatternTree patternTree) throws MetadataException {
        long preDeletedNum = 0L;
        AtomicBoolean isAllLogicalView = new AtomicBoolean(true);
        for (PartialPath pathPattern : patternTree.getAllPathPatterns()) {
            List<PartialPath> paths = this.mTree.constructSchemaBlackList(pathPattern, isAllLogicalView);
            preDeletedNum += (long)paths.size();
            for (PartialPath path : paths) {
                this.writeToMLog(SchemaRegionWritePlanFactory.getPreDeleteTimeSeriesPlan(path));
            }
        }
        return new Pair((Object)preDeletedNum, (Object)isAllLogicalView.get());
    }

    private void recoverPreDeleteTimeseries(PartialPath path) throws MetadataException {
        IMeasurementMNode<IMemMNode> measurementMNode = this.mTree.getMeasurementMNode(path);
        measurementMNode.setPreDeleted(true);
    }

    @Override
    public void rollbackSchemaBlackList(PathPatternTree patternTree) throws MetadataException {
        for (PartialPath pathPattern : patternTree.getAllPathPatterns()) {
            List<PartialPath> paths = this.mTree.rollbackSchemaBlackList(pathPattern);
            for (PartialPath path : paths) {
                this.writeToMLog(SchemaRegionWritePlanFactory.getRollbackPreDeleteTimeSeriesPlan(path));
            }
        }
    }

    @Override
    public Set<PartialPath> fetchSchemaBlackList(PathPatternTree patternTree) throws MetadataException {
        HashSet<PartialPath> deviceBasedPathPatternSet = new HashSet<PartialPath>();
        for (PartialPath pathPattern : patternTree.getAllPathPatterns()) {
            for (PartialPath devicePath : this.mTree.getDevicesOfPreDeletedTimeSeries(pathPattern)) {
                deviceBasedPathPatternSet.addAll(pathPattern.alterPrefixPath(devicePath));
            }
        }
        return deviceBasedPathPatternSet;
    }

    @Override
    public void deleteTimeseriesInBlackList(PathPatternTree patternTree) throws MetadataException {
        for (PartialPath pathPattern : patternTree.getAllPathPatterns()) {
            for (PartialPath path : this.mTree.getPreDeletedTimeSeries(pathPattern)) {
                try {
                    this.deleteSingleTimeseriesInBlackList(path);
                    this.writeToMLog(SchemaRegionWritePlanFactory.getDeleteTimeSeriesPlan(Collections.singletonList(path)));
                }
                catch (IOException e) {
                    throw new MetadataException((Throwable)e);
                }
            }
        }
    }

    @Override
    public void createLogicalView(ICreateLogicalViewPlan plan) throws MetadataException {
        if (!this.regionStatistics.isAllowToCreateNewSeries()) {
            throw new SeriesOverflowException(this.regionStatistics.getGlobalMemoryUsage(), this.regionStatistics.getGlobalSeriesNumber());
        }
        List<PartialPath> pathList = plan.getViewPathList();
        Map<PartialPath, ViewExpression> viewPathToSourceMap = plan.getViewPathToSourceExpressionMap();
        for (PartialPath path : pathList) {
            this.mTree.createLogicalView(path, viewPathToSourceMap.get(path));
        }
        if (!this.isRecovering) {
            this.writeToMLog(plan);
        }
        this.regionStatistics.addView(1L);
    }

    @Override
    public long constructLogicalViewBlackList(PathPatternTree patternTree) throws MetadataException {
        long preDeletedNum = 0L;
        for (PartialPath pathPattern : patternTree.getAllPathPatterns()) {
            List<PartialPath> paths = this.mTree.constructLogicalViewBlackList(pathPattern);
            preDeletedNum += (long)paths.size();
            for (PartialPath path : paths) {
                this.writeToMLog(SchemaRegionWritePlanFactory.getPreDeleteLogicalViewPlan(path));
            }
        }
        return preDeletedNum;
    }

    @Override
    public void rollbackLogicalViewBlackList(PathPatternTree patternTree) throws MetadataException {
        for (PartialPath pathPattern : patternTree.getAllPathPatterns()) {
            List<PartialPath> paths = this.mTree.rollbackLogicalViewBlackList(pathPattern);
            for (PartialPath path : paths) {
                this.writeToMLog(SchemaRegionWritePlanFactory.getRollbackPreDeleteLogicalViewPlan(path));
            }
        }
    }

    @Override
    public void deleteLogicalView(PathPatternTree patternTree) throws MetadataException {
        for (PartialPath pathPattern : patternTree.getAllPathPatterns()) {
            for (PartialPath path : this.mTree.getPreDeletedLogicalView(pathPattern)) {
                try {
                    this.deleteSingleTimeseriesInBlackList(path);
                    this.writeToMLog(SchemaRegionWritePlanFactory.getDeleteLogicalViewPlan(path));
                }
                catch (IOException e) {
                    throw new MetadataException((Throwable)e);
                }
            }
        }
    }

    @Override
    public void alterLogicalView(IAlterLogicalViewPlan alterLogicalViewPlan) throws MetadataException {
        IMeasurementMNode<IMemMNode> leafMNode = this.mTree.getMeasurementMNode(alterLogicalViewPlan.getViewPath());
        if (!leafMNode.isLogicalView()) {
            throw new MetadataException(String.format("[%s] is no view.", alterLogicalViewPlan.getViewPath()));
        }
        leafMNode.setSchema((IMeasurementSchema)new LogicalViewSchema(leafMNode.getName(), alterLogicalViewPlan.getSourceExpression()));
        if (!this.isRecovering) {
            this.writeToMLog(alterLogicalViewPlan);
        }
    }

    private void deleteSingleTimeseriesInBlackList(PartialPath path) throws MetadataException, IOException {
        IMeasurementMNode<IMemMNode> measurementMNode = this.mTree.deleteTimeSeries(path);
        this.removeFromTagInvertedIndex(measurementMNode);
        if (measurementMNode.isLogicalView()) {
            this.regionStatistics.deleteView(1L);
        } else {
            this.regionStatistics.deleteMeasurement(1L);
        }
    }

    private void recoverRollbackPreDeleteTimeseries(PartialPath path) throws MetadataException {
        IMeasurementMNode<IMemMNode> measurementMNode = this.mTree.getMeasurementMNode(path);
        measurementMNode.setPreDeleted(false);
    }

    private void deleteOneTimeseriesUpdateStatistics(PartialPath path) throws MetadataException, IOException {
        IMeasurementMNode<IMemMNode> measurementMNode = this.mTree.deleteTimeSeries(path);
        this.removeFromTagInvertedIndex(measurementMNode);
        if (measurementMNode.isLogicalView()) {
            this.regionStatistics.deleteView(1L);
        } else {
            this.regionStatistics.deleteMeasurement(1L);
        }
    }

    private IMemMNode getDeviceNodeWithAutoCreate(PartialPath path) throws MetadataException {
        IMemMNode node = this.mTree.getDeviceNodeWithAutoCreating(path);
        this.writeToMLog(SchemaRegionWritePlanFactory.getAutoCreateDeviceMNodePlan(node.getPartialPath()));
        return node;
    }

    private void autoCreateDeviceMNode(IAutoCreateDeviceMNodePlan plan) throws MetadataException {
        this.mTree.getDeviceNodeWithAutoCreating(plan.getPath());
        this.writeToMLog(plan);
    }

    @Override
    public MeasurementPath fetchMeasurementPath(PartialPath fullPath) throws MetadataException {
        IMeasurementMNode<IMemMNode> node = this.mTree.getMeasurementMNode(fullPath);
        MeasurementPath res = new MeasurementPath(node.getPartialPath(), node.getSchema());
        res.setUnderAlignedEntity(Boolean.valueOf(((IMemMNode)node.getParent()).getAsDeviceMNode().isAligned()));
        return res;
    }

    @Override
    public ClusterSchemaTree fetchSeriesSchema(PathPatternTree patternTree, Map<Integer, Template> templateMap, boolean withTags, boolean withAttributes, boolean withTemplate, boolean withAliasForce) throws MetadataException {
        if (patternTree.isContainWildcard()) {
            ClusterSchemaTree schemaTree = new ClusterSchemaTree();
            for (PartialPath path : patternTree.getAllPathPatterns()) {
                schemaTree.mergeSchemaTree(this.mTree.fetchSchema(path, templateMap, withTags, withAttributes, withTemplate, withAliasForce));
            }
            return schemaTree;
        }
        return this.mTree.fetchSchemaWithoutWildcard(patternTree, templateMap, withTags, withAttributes, withTemplate);
    }

    @Override
    public ClusterSchemaTree fetchDeviceSchema(PathPatternTree patternTree, PathPatternTree authorityScope) throws MetadataException {
        return this.mTree.fetchDeviceSchema(patternTree, authorityScope);
    }

    private void changeOffset(PartialPath path, long offset) throws MetadataException {
        IMeasurementMNode<IMemMNode> measurementMNode = this.mTree.getMeasurementMNode(path);
        measurementMNode.setOffset(offset);
        if (this.isRecovering) {
            try {
                this.tagManager.recoverIndex(offset, measurementMNode);
            }
            catch (IOException e) {
                throw new MetadataException((Throwable)e);
            }
        }
    }

    @Override
    public void upsertAliasAndTagsAndAttributes(String alias, Map<String, String> tagsMap, Map<String, String> attributesMap, PartialPath fullPath) throws MetadataException, IOException {
        this.upsertAlias(alias, fullPath);
        if (tagsMap != null && !this.regionStatistics.isAllowToCreateNewSeries()) {
            throw new SeriesOverflowException(this.regionStatistics.getGlobalMemoryUsage(), this.regionStatistics.getGlobalSeriesNumber());
        }
        IMeasurementMNode<IMemMNode> leafMNode = this.mTree.getMeasurementMNode(fullPath);
        if (tagsMap == null && attributesMap == null) {
            return;
        }
        if (leafMNode.getOffset() < 0L) {
            long offset = this.tagManager.writeTagFile(tagsMap, attributesMap);
            this.writeToMLog(SchemaRegionWritePlanFactory.getChangeTagOffsetPlan(fullPath, offset));
            leafMNode.setOffset(offset);
            if (tagsMap != null && !tagsMap.isEmpty()) {
                this.tagManager.addIndex(tagsMap, leafMNode);
            }
            return;
        }
        this.tagManager.updateTagsAndAttributes(tagsMap, attributesMap, leafMNode);
    }

    private void upsertAlias(String alias, PartialPath fullPath) throws MetadataException {
        if (alias != null) {
            if (!this.regionStatistics.isAllowToCreateNewSeries()) {
                throw new SeriesOverflowException(this.regionStatistics.getGlobalMemoryUsage(), this.regionStatistics.getGlobalSeriesNumber());
            }
            if (this.mTree.changeAlias(alias, fullPath)) {
                this.writeToMLog(SchemaRegionWritePlanFactory.getChangeAliasPlan(fullPath, alias));
            }
        }
    }

    @Override
    public void addAttributes(Map<String, String> attributesMap, PartialPath fullPath) throws MetadataException, IOException {
        IMeasurementMNode<IMemMNode> leafMNode = this.mTree.getMeasurementMNode(fullPath);
        if (leafMNode.getOffset() < 0L) {
            long offset = this.tagManager.writeTagFile(Collections.emptyMap(), attributesMap);
            this.writeToMLog(SchemaRegionWritePlanFactory.getChangeTagOffsetPlan(fullPath, offset));
            leafMNode.setOffset(offset);
            return;
        }
        this.tagManager.addAttributes(attributesMap, fullPath, leafMNode);
    }

    @Override
    public void addTags(Map<String, String> tagsMap, PartialPath fullPath) throws MetadataException, IOException {
        if (!this.regionStatistics.isAllowToCreateNewSeries()) {
            throw new SeriesOverflowException(this.regionStatistics.getGlobalMemoryUsage(), this.regionStatistics.getGlobalSeriesNumber());
        }
        IMeasurementMNode<IMemMNode> leafMNode = this.mTree.getMeasurementMNode(fullPath);
        if (leafMNode.getOffset() < 0L) {
            long offset = this.tagManager.writeTagFile(tagsMap, Collections.emptyMap());
            this.writeToMLog(SchemaRegionWritePlanFactory.getChangeTagOffsetPlan(fullPath, offset));
            leafMNode.setOffset(offset);
            this.tagManager.addIndex(tagsMap, leafMNode);
            return;
        }
        this.tagManager.addTags(tagsMap, fullPath, leafMNode);
    }

    @Override
    public void dropTagsOrAttributes(Set<String> keySet, PartialPath fullPath) throws MetadataException, IOException {
        IMeasurementMNode<IMemMNode> leafMNode = this.mTree.getMeasurementMNode(fullPath);
        if (leafMNode.getOffset() != -1L) {
            this.tagManager.dropTagsOrAttributes(keySet, fullPath, leafMNode);
        }
    }

    @Override
    public void setTagsOrAttributesValue(Map<String, String> alterMap, PartialPath fullPath) throws MetadataException, IOException {
        if (!this.regionStatistics.isAllowToCreateNewSeries()) {
            throw new SeriesOverflowException(this.regionStatistics.getGlobalMemoryUsage(), this.regionStatistics.getGlobalSeriesNumber());
        }
        IMeasurementMNode<IMemMNode> leafMNode = this.mTree.getMeasurementMNode(fullPath);
        if (leafMNode.getOffset() < 0L) {
            throw new MetadataException(String.format("TimeSeries [%s] does not have any tag/attribute.", fullPath));
        }
        this.tagManager.setTagsOrAttributesValue(alterMap, fullPath, leafMNode);
    }

    @Override
    public void renameTagOrAttributeKey(String oldKey, String newKey, PartialPath fullPath) throws MetadataException, IOException {
        if (!this.regionStatistics.isAllowToCreateNewSeries()) {
            throw new SeriesOverflowException(this.regionStatistics.getGlobalMemoryUsage(), this.regionStatistics.getGlobalSeriesNumber());
        }
        IMeasurementMNode<IMemMNode> leafMNode = this.mTree.getMeasurementMNode(fullPath);
        if (leafMNode.getOffset() < 0L) {
            throw new MetadataException(String.format("TimeSeries [%s] does not have [%s] tag/attribute.", fullPath, oldKey), true);
        }
        this.tagManager.renameTagOrAttributeKey(oldKey, newKey, fullPath, leafMNode);
    }

    private void removeFromTagInvertedIndex(IMeasurementMNode<IMemMNode> node) throws IOException {
        this.tagManager.removeFromTagInvertedIndex(node);
    }

    @Override
    public void activateSchemaTemplate(IActivateTemplateInClusterPlan plan, Template template) throws MetadataException {
        if (!this.regionStatistics.isAllowToCreateNewSeries()) {
            throw new SeriesOverflowException(this.regionStatistics.getGlobalMemoryUsage(), this.regionStatistics.getGlobalSeriesNumber());
        }
        plan.setAligned(template.isDirectAligned());
        this.getDeviceNodeWithAutoCreate(plan.getActivatePath());
        this.mTree.activateTemplate(plan.getActivatePath(), template);
        this.writeToMLog(plan);
    }

    private void recoverActivatingSchemaTemplate(IActivateTemplateInClusterPlan plan) {
        this.mTree.activateTemplateWithoutCheck(plan.getActivatePath(), plan.getTemplateId(), plan.isAligned());
    }

    @Override
    public long constructSchemaBlackListWithTemplate(IPreDeactivateTemplatePlan plan) throws MetadataException {
        Map<PartialPath, List<Integer>> resultTemplateSetInfo = this.mTree.constructSchemaBlackListWithTemplate(plan.getTemplateSetInfo());
        this.writeToMLog(SchemaRegionWritePlanFactory.getPreDeactivateTemplatePlan(resultTemplateSetInfo));
        return resultTemplateSetInfo.size();
    }

    @Override
    public void rollbackSchemaBlackListWithTemplate(IRollbackPreDeactivateTemplatePlan plan) throws MetadataException {
        Map<PartialPath, List<Integer>> resultTemplateSetInfo = this.mTree.rollbackSchemaBlackListWithTemplate(plan.getTemplateSetInfo());
        this.writeToMLog(SchemaRegionWritePlanFactory.getRollbackPreDeactivateTemplatePlan(resultTemplateSetInfo));
    }

    @Override
    public void deactivateTemplateInBlackList(IDeactivateTemplatePlan plan) throws MetadataException {
        Map<PartialPath, List<Integer>> resultTemplateSetInfo = this.mTree.deactivateTemplateInBlackList(plan.getTemplateSetInfo());
        this.writeToMLog(SchemaRegionWritePlanFactory.getDeactivateTemplatePlan(resultTemplateSetInfo));
    }

    @Override
    public long countPathsUsingTemplate(int templateId, PathPatternTree patternTree) throws MetadataException {
        long result = 0L;
        for (PartialPath pathPattern : patternTree.getAllPathPatterns()) {
            result += this.mTree.countPathsUsingTemplate(pathPattern, templateId);
        }
        return result;
    }

    @Override
    public int fillLastQueryMap(PartialPath pattern, Map<TableId, Map<IDeviceID, Map<String, Pair<TSDataType, TimeValuePair>>>> mapToFill) throws MetadataException {
        return this.mTree.fillLastQueryMap(pattern, mapToFill);
    }

    @Override
    public void createOrUpdateTableDevice(CreateOrUpdateTableDeviceNode node) throws MetadataException {
        for (int i = 0; i < node.getDeviceIdList().size(); ++i) {
            String databaseName = this.databaseFullPath;
            String tableName = node.getTableName();
            String[] deviceId = (String[])Arrays.stream(node.getDeviceIdList().get(i)).map(o -> Objects.nonNull(o) ? o.toString() : null).toArray(String[]::new);
            List<String> attributeNameList = node.getAttributeNameList();
            Object[] attributeValueList = node.getAttributeValueList().get(i);
            this.mTree.createOrUpdateTableDevice(tableName, deviceId, () -> this.deviceAttributeStore.createAttribute(attributeNameList, attributeValueList, node.getTableName()), pointer -> {
                this.updateAttribute(databaseName, tableName, deviceId, pointer, attributeNameList, attributeValueList);
                this.deviceAttributeCacheUpdater.afterUpdate();
            });
        }
        this.writeToMLog(node);
    }

    private void updateAttribute(String databaseName, String tableName, String[] deviceId, int pointer, List<String> attributeNameList, Object[] attributeValueList) {
        Map<String, Binary> resultMap = this.deviceAttributeStore.alterAttribute(pointer, attributeNameList, attributeValueList, tableName);
        if (!this.isRecovering) {
            TableDeviceSchemaCache.getInstance().updateAttributes(databaseName, TableDeviceSchemaFetcher.convertTagValuesToDeviceID(tableName, deviceId), resultMap);
        }
        this.deviceAttributeCacheUpdater.update(tableName, deviceId, resultMap);
    }

    @Override
    public void updateTableDeviceAttribute(TableDeviceAttributeUpdateNode updateNode) throws MetadataException {
        try (DeviceAttributeUpdater batchUpdater = this.constructDevicePredicateUpdater(updateNode);){
            for (PartialPath pattern : TableDeviceQuerySource.getDevicePatternList(updateNode.getDatabase(), DataNodeTableCache.getInstance().getTable(updateNode.getDatabase(), updateNode.getTableName()), updateNode.getTagDeterminedFilterList())) {
                this.mTree.updateTableDevice(pattern, batchUpdater);
            }
        }
        this.deviceAttributeCacheUpdater.afterUpdate();
        this.writeToMLog(updateNode);
    }

    private DeviceAttributeUpdater constructDevicePredicateUpdater(TableDeviceAttributeUpdateNode updateNode) {
        String database = updateNode.getDatabase();
        String tableName = updateNode.getTableName();
        TsTable table = DataNodeTableCache.getInstance().getTable(database, tableName);
        Expression predicate = updateNode.getTagFuzzyPredicate();
        List<TsTableColumnSchema> columnSchemaList = updateNode.getColumnHeaderList().stream().map(columnHeader -> table.getColumnSchema(columnHeader.getColumnName())).collect(Collectors.toList());
        Map<Symbol, List<InputLocation>> inputLocations = TableOperatorGenerator.makeLayout(Collections.singletonList(updateNode));
        SessionInfo sessionInfo = updateNode.getSessionInfo();
        TypeProvider mockTypeProvider = new TypeProvider(columnSchemaList.stream().collect(Collectors.toMap(columnSchema -> new Symbol(columnSchema.getColumnName()), columnSchema -> TypeFactory.getType((TSDataType)columnSchema.getDataType()))));
        Metadata metadata = LocalExecutionPlanner.getInstance().metadata;
        ArrayList<LeafColumnTransformer> filterLeafColumnTransformerList = new ArrayList<LeafColumnTransformer>();
        HashMap<Expression, ColumnTransformer> filterExpressionColumnTransformerMap = new HashMap<Expression, ColumnTransformer>();
        ColumnTransformerBuilder visitor = new ColumnTransformerBuilder();
        ColumnTransformer filterOutputTransformer = Objects.nonNull(predicate) ? (ColumnTransformer)visitor.process(predicate, new ColumnTransformerBuilder.Context(sessionInfo, filterLeafColumnTransformerList, inputLocations, filterExpressionColumnTransformerMap, (Map<Expression, ColumnTransformer>)ImmutableMap.of(), (List<ColumnTransformer>)ImmutableList.of(), (List<TSDataType>)ImmutableList.of(), 0, mockTypeProvider, metadata)) : null;
        List<TSDataType> filterOutputDataTypes = columnSchemaList.stream().map(TsTableColumnSchema::getDataType).collect(Collectors.toList());
        ArrayList<LeafColumnTransformer> projectLeafColumnTransformerList = new ArrayList<LeafColumnTransformer>();
        HashMap<Expression, ColumnTransformer> projectExpressionColumnTransformerMap = new HashMap<Expression, ColumnTransformer>();
        ArrayList<ColumnTransformer> commonTransformerList = new ArrayList<ColumnTransformer>();
        ColumnTransformerBuilder.Context projectColumnTransformerContext = new ColumnTransformerBuilder.Context(sessionInfo, projectLeafColumnTransformerList, inputLocations, projectExpressionColumnTransformerMap, filterExpressionColumnTransformerMap, commonTransformerList, filterOutputDataTypes, inputLocations.size(), mockTypeProvider, metadata);
        List<String> attributeNames = updateNode.getAssignments().stream().map(assignment -> ((SymbolReference)assignment.getName()).getName()).collect(Collectors.toList());
        return new DeviceAttributeUpdater(filterOutputDataTypes, filterLeafColumnTransformerList, filterOutputTransformer, commonTransformerList, columnSchemaList, projectLeafColumnTransformerList, updateNode.getAssignments().stream().map(assignment -> (ColumnTransformer)visitor.process(assignment.getValue(), projectColumnTransformerContext)).collect(Collectors.toList()), (pointer, name) -> this.deviceAttributeStore.getAttributes((int)pointer, (String)name), (TriConsumer<String[], Integer, Object[]>)((TriConsumer)(deviceId, pointer, values) -> this.updateAttribute(database, tableName, (String[])deviceId, (int)pointer, attributeNames, (Object[])values)), attributeNames, database, table);
    }

    @Override
    public void deleteTableDevice(DeleteTableDeviceNode deleteTableDeviceNode) throws MetadataException {
        if (this.mTree.deleteTableDevice(deleteTableDeviceNode.getTableName(), size -> this.deviceAttributeStore.removeAttribute(size, deleteTableDeviceNode.getTableName()))) {
            this.deviceAttributeCacheUpdater.invalidate(deleteTableDeviceNode.getTableName());
            this.writeToMLog(deleteTableDeviceNode);
        }
    }

    @Override
    public void dropTableAttribute(TableAttributeColumnDropNode dropTableAttributeNode) throws MetadataException {
        if (this.mTree.dropTableAttribute(dropTableAttributeNode.getTableName(), pointer -> this.deviceAttributeStore.removeAttribute(pointer, dropTableAttributeNode.getColumnName(), dropTableAttributeNode.getTableName()))) {
            this.deviceAttributeCacheUpdater.invalidate(dropTableAttributeNode.getTableName(), dropTableAttributeNode.getColumnName());
            this.writeToMLog(dropTableAttributeNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long constructTableDevicesBlackList(ConstructTableDevicesBlackListNode constructTableDevicesBlackListNode) throws MetadataException {
        List<PartialPath> paths = DeleteDevice.constructPaths(this.databaseFullPath, constructTableDevicesBlackListNode.getTableName(), constructTableDevicesBlackListNode.getPatternInfo());
        try (DeviceBlackListConstructor constructor = DeleteDevice.constructDevicePredicateUpdater(this.databaseFullPath, DataNodeTableCache.getInstance().getTable(this.databaseFullPath, constructTableDevicesBlackListNode.getTableName()), constructTableDevicesBlackListNode.getFilterInfo(), (pointer, name) -> this.deviceAttributeStore.getAttributes((int)pointer, (String)name), this.regionStatistics);){
            for (PartialPath pattern : paths) {
                this.mTree.constructTableDeviceBlackList(pattern, constructor);
            }
        }
        this.writeToMLog(constructTableDevicesBlackListNode);
        return constructor.getPreDeletedNum();
    }

    @Override
    public void rollbackTableDevicesBlackList(RollbackTableDevicesBlackListNode rollbackTableDevicesBlackListNode) throws MetadataException {
        List<PartialPath> paths = DeleteDevice.constructPaths(PathUtils.unQualifyDatabaseName((String)this.databaseFullPath), rollbackTableDevicesBlackListNode.getTableName(), rollbackTableDevicesBlackListNode.getPatternInfo());
        for (PartialPath pattern : paths) {
            this.mTree.rollbackTableDeviceBlackList(pattern);
        }
        this.writeToMLog(rollbackTableDevicesBlackListNode);
    }

    @Override
    public void deleteTableDevicesInBlackList(DeleteTableDevicesInBlackListNode rollbackTableDevicesBlackListNode) throws MetadataException {
        List<PartialPath> paths = DeleteDevice.constructPaths(PathUtils.unQualifyDatabaseName((String)this.databaseFullPath), rollbackTableDevicesBlackListNode.getTableName(), rollbackTableDevicesBlackListNode.getPatternInfo());
        for (PartialPath pattern : paths) {
            this.mTree.deleteTableDevicesInBlackList(pattern, size -> this.deviceAttributeStore.removeAttribute(size, rollbackTableDevicesBlackListNode.getTableName()), this.deviceAttributeCacheUpdater::invalidate);
        }
        this.writeToMLog(rollbackTableDevicesBlackListNode);
    }

    @Override
    public ISchemaReader<IDeviceSchemaInfo> getDeviceReader(IShowDevicesPlan showDevicesPlan) throws MetadataException {
        return this.mTree.getDeviceReader(showDevicesPlan, (pointer, name) -> this.deviceAttributeStore.getAttributes((int)pointer, (String)name));
    }

    @Override
    public ISchemaReader<ITimeSeriesSchemaInfo> getTimeSeriesReader(IShowTimeSeriesPlan showTimeSeriesPlan) throws MetadataException {
        if (showTimeSeriesPlan.getSchemaFilter() != null && new FilterContainsVisitor().process(showTimeSeriesPlan.getSchemaFilter(), SchemaFilterType.TAGS_FILTER).booleanValue()) {
            return this.tagManager.getTimeSeriesReaderWithIndex(showTimeSeriesPlan);
        }
        return this.mTree.getTimeSeriesReader(showTimeSeriesPlan, offset -> {
            try {
                return this.tagManager.readTagFile((long)offset);
            }
            catch (IOException e) {
                logger.error("Failed to read tag and attribute info because {}", (Object)e.getMessage(), (Object)e);
                return new Pair(Collections.emptyMap(), Collections.emptyMap());
            }
        });
    }

    @Override
    public ISchemaReader<INodeSchemaInfo> getNodeReader(IShowNodesPlan showNodesPlan) throws MetadataException {
        return this.mTree.getNodeReader(showNodesPlan);
    }

    @Override
    public ISchemaReader<IDeviceSchemaInfo> getTableDeviceReader(PartialPath pathPattern) throws MetadataException {
        return this.mTree.getTableDeviceReader(pathPattern, (Integer pointer, String name) -> this.deviceAttributeStore.getAttributes((int)pointer, (String)name));
    }

    @Override
    public ISchemaReader<IDeviceSchemaInfo> getTableDeviceReader(String table, List<Object[]> devicePathList) {
        return this.mTree.getTableDeviceReader(table, devicePathList, (pointer, name) -> this.deviceAttributeStore.getAttributes((int)pointer, (String)name));
    }

    @Override
    public Pair<Long, Map<TDataNodeLocation, byte[]>> getAttributeUpdateInfo(AtomicInteger limit, AtomicBoolean hasRemaining) {
        return this.deviceAttributeCacheUpdater.getAttributeUpdateInfo(limit, hasRemaining);
    }

    @Override
    public void commitUpdateAttribute(TableDeviceAttributeCommitUpdateNode node) throws MetadataException {
        this.deviceAttributeCacheUpdater.commit(node);
        this.writeToMLog(node);
    }

    @Override
    public void addNodeLocation(TableNodeLocationAddNode node) throws MetadataException {
        if (this.deviceAttributeCacheUpdater.addLocation(node.getLocation())) {
            this.writeToMLog(node);
        }
    }

    private class RecoverPlanOperator
    extends SchemaRegionPlanVisitor<RecoverOperationResult, SchemaRegionMemoryImpl> {
        private RecoverPlanOperator() {
        }

        @Override
        public RecoverOperationResult visitSchemaRegionPlan(ISchemaRegionPlan plan, SchemaRegionMemoryImpl context) {
            throw new UnsupportedOperationException(String.format("SchemaRegionPlan of type %s doesn't support recover operation in SchemaRegionMemoryImpl.", plan.getPlanType().name()));
        }

        @Override
        public RecoverOperationResult visitCreateTimeSeries(ICreateTimeSeriesPlan createTimeSeriesPlan, SchemaRegionMemoryImpl context) {
            try {
                SchemaRegionMemoryImpl.this.createTimeSeries(createTimeSeriesPlan, createTimeSeriesPlan.getTagOffset());
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitCreateAlignedTimeSeries(ICreateAlignedTimeSeriesPlan createAlignedTimeSeriesPlan, SchemaRegionMemoryImpl context) {
            try {
                SchemaRegionMemoryImpl.this.createAlignedTimeSeries(createAlignedTimeSeriesPlan);
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitDeleteTimeSeries(IDeleteTimeSeriesPlan deleteTimeSeriesPlan, SchemaRegionMemoryImpl context) {
            try {
                SchemaRegionMemoryImpl.this.deleteOneTimeseriesUpdateStatistics(deleteTimeSeriesPlan.getDeletePathList().get(0));
                return RecoverOperationResult.SUCCESS;
            }
            catch (IOException | MetadataException e) {
                return new RecoverOperationResult((Exception)e);
            }
        }

        @Override
        public RecoverOperationResult visitChangeAlias(IChangeAliasPlan changeAliasPlan, SchemaRegionMemoryImpl context) {
            try {
                SchemaRegionMemoryImpl.this.upsertAlias(changeAliasPlan.getAlias(), changeAliasPlan.getPath());
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitChangeTagOffset(IChangeTagOffsetPlan changeTagOffsetPlan, SchemaRegionMemoryImpl context) {
            try {
                SchemaRegionMemoryImpl.this.changeOffset(changeTagOffsetPlan.getPath(), changeTagOffsetPlan.getOffset());
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitAutoCreateDeviceMNode(IAutoCreateDeviceMNodePlan autoCreateDeviceMNodePlan, SchemaRegionMemoryImpl context) {
            try {
                SchemaRegionMemoryImpl.this.autoCreateDeviceMNode(autoCreateDeviceMNodePlan);
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitActivateTemplateInCluster(IActivateTemplateInClusterPlan activateTemplateInClusterPlan, SchemaRegionMemoryImpl context) {
            SchemaRegionMemoryImpl.this.recoverActivatingSchemaTemplate(activateTemplateInClusterPlan);
            return RecoverOperationResult.SUCCESS;
        }

        @Override
        public RecoverOperationResult visitPreDeleteTimeSeries(IPreDeleteTimeSeriesPlan preDeleteTimeSeriesPlan, SchemaRegionMemoryImpl context) {
            try {
                SchemaRegionMemoryImpl.this.recoverPreDeleteTimeseries(preDeleteTimeSeriesPlan.getPath());
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitRollbackPreDeleteTimeSeries(IRollbackPreDeleteTimeSeriesPlan rollbackPreDeleteTimeSeriesPlan, SchemaRegionMemoryImpl context) {
            try {
                SchemaRegionMemoryImpl.this.recoverRollbackPreDeleteTimeseries(rollbackPreDeleteTimeSeriesPlan.getPath());
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitPreDeactivateTemplate(IPreDeactivateTemplatePlan preDeactivateTemplatePlan, SchemaRegionMemoryImpl context) {
            try {
                SchemaRegionMemoryImpl.this.constructSchemaBlackListWithTemplate(preDeactivateTemplatePlan);
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitRollbackPreDeactivateTemplate(IRollbackPreDeactivateTemplatePlan rollbackPreDeactivateTemplatePlan, SchemaRegionMemoryImpl context) {
            try {
                SchemaRegionMemoryImpl.this.rollbackSchemaBlackListWithTemplate(rollbackPreDeactivateTemplatePlan);
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitDeactivateTemplate(IDeactivateTemplatePlan deactivateTemplatePlan, SchemaRegionMemoryImpl context) {
            try {
                SchemaRegionMemoryImpl.this.deactivateTemplateInBlackList(deactivateTemplatePlan);
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitCreateLogicalView(ICreateLogicalViewPlan createLogicalViewPlan, SchemaRegionMemoryImpl context) {
            try {
                SchemaRegionMemoryImpl.this.createLogicalView(createLogicalViewPlan);
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitPreDeleteLogicalView(IPreDeleteLogicalViewPlan preDeleteLogicalViewPlan, SchemaRegionMemoryImpl context) {
            try {
                SchemaRegionMemoryImpl.this.recoverPreDeleteTimeseries(preDeleteLogicalViewPlan.getPath());
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitRollbackPreDeleteLogicalView(IRollbackPreDeleteLogicalViewPlan rollbackPreDeleteLogicalViewPlan, SchemaRegionMemoryImpl context) {
            try {
                SchemaRegionMemoryImpl.this.recoverRollbackPreDeleteTimeseries(rollbackPreDeleteLogicalViewPlan.getPath());
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitDeleteLogicalView(IDeleteLogicalViewPlan deleteLogicalViewPlan, SchemaRegionMemoryImpl context) {
            try {
                SchemaRegionMemoryImpl.this.deleteOneTimeseriesUpdateStatistics(deleteLogicalViewPlan.getPath());
                return RecoverOperationResult.SUCCESS;
            }
            catch (IOException | MetadataException e) {
                return new RecoverOperationResult((Exception)e);
            }
        }

        @Override
        public RecoverOperationResult visitCreateOrUpdateTableDevice(CreateOrUpdateTableDeviceNode createOrUpdateTableDeviceNode, SchemaRegionMemoryImpl context) {
            try {
                SchemaRegionMemoryImpl.this.createOrUpdateTableDevice(createOrUpdateTableDeviceNode);
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitUpdateTableDeviceAttribute(TableDeviceAttributeUpdateNode updateTableDeviceAttributePlan, SchemaRegionMemoryImpl context) {
            try {
                SchemaRegionMemoryImpl.this.updateTableDeviceAttribute(updateTableDeviceAttributePlan);
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitCommitUpdateTableDeviceAttribute(TableDeviceAttributeCommitUpdateNode commitUpdateTableDeviceAttributePlan, SchemaRegionMemoryImpl context) {
            try {
                SchemaRegionMemoryImpl.this.commitUpdateAttribute(commitUpdateTableDeviceAttributePlan);
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitAddNodeLocation(TableNodeLocationAddNode addNodeLocationPlan, SchemaRegionMemoryImpl context) {
            try {
                SchemaRegionMemoryImpl.this.addNodeLocation(addNodeLocationPlan);
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitDeleteTableDevice(DeleteTableDeviceNode deleteTableDevicePlan, SchemaRegionMemoryImpl context) {
            try {
                SchemaRegionMemoryImpl.this.deleteTableDevice(deleteTableDevicePlan);
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitConstructTableDevicesBlackList(ConstructTableDevicesBlackListNode constructTableDevicesBlackListPlan, SchemaRegionMemoryImpl context) {
            try {
                SchemaRegionMemoryImpl.this.constructTableDevicesBlackList(constructTableDevicesBlackListPlan);
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitRollbackTableDevicesBlackList(RollbackTableDevicesBlackListNode constructTableDevicesBlackListPlan, SchemaRegionMemoryImpl context) {
            try {
                SchemaRegionMemoryImpl.this.rollbackTableDevicesBlackList(constructTableDevicesBlackListPlan);
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitDeleteTableDevicesInBlackList(DeleteTableDevicesInBlackListNode deleteTableDevicesInBlackListPlan, SchemaRegionMemoryImpl context) {
            try {
                SchemaRegionMemoryImpl.this.deleteTableDevicesInBlackList(deleteTableDevicesInBlackListPlan);
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitDropTableAttribute(TableAttributeColumnDropNode dropTableAttributePlan, SchemaRegionMemoryImpl context) {
            try {
                SchemaRegionMemoryImpl.this.dropTableAttribute(dropTableAttributePlan);
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }
    }

    private static class RecoverOperationResult {
        private static final RecoverOperationResult SUCCESS = new RecoverOperationResult(null);
        private final Exception e;

        private RecoverOperationResult(Exception e) {
            this.e = e;
        }

        private boolean isFailed() {
            return this.e != null;
        }

        private Exception getException() {
            return this.e;
        }
    }
}

