/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.config;

import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.rpc.thrift.Node;

public class ClusterConstant {
    private static long electionMaxWaitMs = Math.max(ClusterDescriptor.getInstance().getConfig().getHeartbeatIntervalMs(), 50L);
    private static final int heartbeatClientConnTimeoutMs = Math.min((int)ClusterConstant.getHeartbeatIntervalMs(), ClusterConstant.getConnectionTimeoutInMS());
    public static final int SLOT_NUM = 10000;
    public static final int HASH_SALT = 2333;
    public static final int CHECK_ALIVE_TIME_OUT_MS = 1000;
    public static final int LOG_NUM_IN_BATCH = 100;
    public static final int RETRY_WAIT_TIME_MS = 10;
    public static final int THREAD_POLL_WAIT_TERMINATION_TIME_S = 10;
    public static final int REPORT_INTERVAL_SEC = 10;
    public static final long CLEAN_HARDLINK_INTERVAL_SEC = 3600L;
    public static final Node EMPTY_NODE = new Node();
    private static int connectionTimeoutInMS = ClusterDescriptor.getInstance().getConfig().getConnectionTimeoutInMS();
    private static int readOperationTimeoutMS = ClusterDescriptor.getInstance().getConfig().getReadOperationTimeoutMS();
    private static int writeOperationTimeoutMS = ClusterDescriptor.getInstance().getConfig().getWriteOperationTimeoutMS();
    private static int syncLeaderMaxWaitMs = 20000;
    private static long heartbeatIntervalMs = ClusterDescriptor.getInstance().getConfig().getHeartbeatIntervalMs();
    private static long electionTimeoutMs = ClusterDescriptor.getInstance().getConfig().getElectionTimeoutMs();

    private ClusterConstant() {
    }

    public static long getElectionMaxWaitMs() {
        return electionMaxWaitMs;
    }

    public static void setElectionMaxWaitMs(long electionMaxWaitMs) {
        ClusterConstant.electionMaxWaitMs = electionMaxWaitMs;
    }

    public static int getConnectionTimeoutInMS() {
        return connectionTimeoutInMS;
    }

    public static void setConnectionTimeoutInMS(int connectionTimeoutInMS) {
        ClusterConstant.connectionTimeoutInMS = connectionTimeoutInMS;
    }

    public static int getReadOperationTimeoutMS() {
        return readOperationTimeoutMS;
    }

    public static int getWriteOperationTimeoutMS() {
        return writeOperationTimeoutMS;
    }

    public static int getSyncLeaderMaxWaitMs() {
        return syncLeaderMaxWaitMs;
    }

    public static void setSyncLeaderMaxWaitMs(int syncLeaderMaxWaitMs) {
        ClusterConstant.syncLeaderMaxWaitMs = syncLeaderMaxWaitMs;
    }

    public static long getHeartbeatIntervalMs() {
        return heartbeatIntervalMs;
    }

    public static void setHeartbeatIntervalMs(long heartBeatIntervalMs) {
        heartbeatIntervalMs = heartBeatIntervalMs;
    }

    public static long getElectionTimeoutMs() {
        return electionTimeoutMs;
    }

    public static void setElectionTimeoutMs(long electionTimeoutMs) {
        ClusterConstant.electionTimeoutMs = electionTimeoutMs;
    }

    public static int getHeartbeatClientConnTimeoutMs() {
        return heartbeatClientConnTimeoutMs;
    }

    public static void setReadOperationTimeoutMS(int readOperationTimeoutMS) {
        ClusterConstant.readOperationTimeoutMS = readOperationTimeoutMS;
    }

    public static void setWriteOperationTimeoutMS(int writeOperationTimeoutMS) {
        ClusterConstant.writeOperationTimeoutMS = writeOperationTimeoutMS;
    }
}

