/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.strategy.optimizer;

import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.exception.query.LogicalOperatorException;
import org.apache.iotdb.db.exception.query.LogicalOptimizeException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.constant.FilterConstant;
import org.apache.iotdb.db.qp.logical.crud.FilterOperator;
import org.apache.iotdb.db.qp.logical.crud.FunctionOperator;
import org.apache.iotdb.db.qp.strategy.optimizer.IFilterOptimizer;

public class RemoveNotOptimizer
implements IFilterOptimizer {
    @Override
    public FilterOperator optimize(FilterOperator filter) throws LogicalOperatorException {
        Set<PartialPath> pathSet = filter.getPathSet();
        FilterOperator optimizedFilterOperator = this.removeNot(filter);
        optimizedFilterOperator.setPathSet(pathSet);
        return optimizedFilterOperator;
    }

    private FilterOperator removeNot(FilterOperator filter) throws LogicalOperatorException {
        if (filter.isLeaf()) {
            return filter;
        }
        FilterConstant.FilterType filterType = filter.getFilterType();
        switch (filterType) {
            case KW_AND: 
            case KW_OR: {
                List<FilterOperator> children = filter.getChildren();
                if (children.size() < 2) {
                    throw new LogicalOptimizeException("Filter has some time series don't correspond to any known time series");
                }
                children.set(0, this.removeNot(children.get(0)));
                children.set(1, this.removeNot(children.get(1)));
                return filter;
            }
            case KW_NOT: {
                if (filter.getChildren().size() < 1) {
                    throw new LogicalOptimizeException("Filter has some time series don't correspond to any known time series");
                }
                return this.reverseFilter(filter.getChildren().get(0));
            }
        }
        throw new LogicalOptimizeException("removeNot", filterType);
    }

    private FilterOperator reverseFilter(FilterOperator filter) throws LogicalOperatorException {
        FilterConstant.FilterType filterType = filter.getFilterType();
        if (filter.isLeaf()) {
            ((FunctionOperator)filter).reverseFunc();
            return filter;
        }
        switch (filterType) {
            case KW_AND: 
            case KW_OR: {
                List<FilterOperator> children = filter.getChildren();
                children.set(0, this.reverseFilter(children.get(0)));
                children.set(1, this.reverseFilter(children.get(1)));
                filter.setFilterType(FilterConstant.filterReverseWords.get((Object)filterType));
                return filter;
            }
            case KW_NOT: {
                return this.removeNot(filter.getChildren().get(0));
            }
        }
        throw new LogicalOptimizeException("reverseFilter", filterType);
    }
}

