/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.v2.file.metadata;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.v2.file.metadata.statistics.StatisticsV2;

public class ChunkMetadataV2 {
    private ChunkMetadataV2() {
    }

    public static ChunkMetadata deserializeFrom(ByteBuffer buffer) {
        String measurementUid = ReadWriteIOUtils.readString(buffer);
        long offsetOfChunkHeader = ReadWriteIOUtils.readLong(buffer);
        TSDataType tsDataType = TSDataType.deserialize((byte)ReadWriteIOUtils.readShort(buffer));
        Statistics<? extends Serializable> statistics = StatisticsV2.deserialize(buffer, tsDataType);
        ChunkMetadata chunkMetaData = new ChunkMetadata(measurementUid, tsDataType, offsetOfChunkHeader, statistics);
        chunkMetaData.setFromOldTsFile(true);
        return chunkMetaData;
    }
}

