/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.util;

import com.netflix.servo.util.Throwables;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public final class Memoizer<T> {
    private volatile long whenItExpires = 0L;
    private volatile T value;
    private final Callable<T> getter;
    private final long durationNanos;

    public static <T> Memoizer<T> create(Callable<T> getter, long duration, TimeUnit unit) {
        return new Memoizer<T>(getter, duration, unit);
    }

    private Memoizer(Callable<T> getter, long duration, TimeUnit unit) {
        this.durationNanos = unit.toNanos(duration);
        this.getter = getter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        long expiration = this.whenItExpires;
        long now = System.nanoTime();
        if (expiration == 0L || now >= expiration) {
            Memoizer memoizer = this;
            synchronized (memoizer) {
                if (this.whenItExpires == expiration) {
                    this.whenItExpires = now + this.durationNanos;
                    try {
                        this.value = this.getter.call();
                    }
                    catch (Exception e) {
                        throw Throwables.propagate(e);
                    }
                }
            }
        }
        return this.value;
    }
}

