/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.instance;

import java.util.UUID;
import org.apache.seata.common.XID;
import org.apache.seata.common.holder.ObjectHolder;
import org.apache.seata.common.metadata.Instance;
import org.apache.seata.common.metadata.Node;
import org.apache.seata.server.instance.AbstractSeataInstanceStrategy;
import org.apache.seata.server.instance.SeataInstanceStrategy;
import org.apache.seata.server.store.StoreConfig;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;

public class GeneralInstanceStrategy
extends AbstractSeataInstanceStrategy {
    public Instance serverInstanceInit() {
        ConfigurableEnvironment environment = (ConfigurableEnvironment)ObjectHolder.INSTANCE.getObject("springConfigurableEnvironment");
        Instance instance = Instance.getInstance();
        String namespace = this.registryNamingServerProperties.getNamespace();
        instance.setNamespace(namespace);
        String clusterName = this.registryNamingServerProperties.getCluster();
        instance.setClusterName(clusterName);
        String clusterType = String.valueOf(StoreConfig.getSessionMode());
        instance.addMetadata("cluster-type", (Object)("raft".equals(clusterType) ? clusterType : "default"));
        instance.setUnit(String.valueOf(UUID.randomUUID()));
        instance.setTerm(System.currentTimeMillis());
        instance.setControl(new Node.Endpoint(XID.getIpAddress(), this.serverProperties.getPort().intValue(), "http"));
        for (PropertySource propertySource : environment.getPropertySources()) {
            if (!(propertySource instanceof EnumerablePropertySource)) continue;
            EnumerablePropertySource enumerablePropertySource = (EnumerablePropertySource)propertySource;
            for (String propertyName : enumerablePropertySource.getPropertyNames()) {
                if (!propertyName.startsWith("seata.registry.metadata.")) continue;
                instance.addMetadata(propertyName.substring("seata.registry.metadata.".length()), enumerablePropertySource.getProperty(propertyName));
            }
        }
        return instance;
    }

    public SeataInstanceStrategy.Type type() {
        return SeataInstanceStrategy.Type.GENERAL;
    }
}

