/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.cdi;

import io.smallrye.jwt.auth.cdi.CDILogging;
import io.smallrye.jwt.auth.cdi.CommonJwtProducer;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.Optional;
import org.eclipse.microprofile.jwt.Claim;

public class JsonValueProducer {
    @Inject
    CommonJwtProducer util;

    @Produces
    @Claim(value="")
    public JsonString getJsonString(InjectionPoint ip) {
        return (JsonString)this.getValue(ip);
    }

    @Produces
    @Claim(value="")
    public Optional<JsonString> getOptionalJsonString(InjectionPoint ip) {
        return this.getOptionalValue(ip);
    }

    @Produces
    @Claim(value="")
    public JsonNumber getJsonNumber(InjectionPoint ip) {
        return (JsonNumber)this.getValue(ip);
    }

    @Produces
    @Claim(value="")
    public Optional<JsonNumber> getOptionalJsonNumber(InjectionPoint ip) {
        return this.getOptionalValue(ip);
    }

    @Produces
    @Claim(value="")
    public JsonArray getJsonArray(InjectionPoint ip) {
        return (JsonArray)this.getValue(ip);
    }

    @Produces
    @Claim(value="")
    public Optional<JsonArray> getOptionalJsonArray(InjectionPoint ip) {
        return this.getOptionalValue(ip);
    }

    @Produces
    @Claim(value="")
    public JsonObject getJsonObject(InjectionPoint ip) {
        return (JsonObject)this.getValue(ip);
    }

    @Produces
    @Claim(value="")
    public Optional<JsonObject> getOptionalJsonObject(InjectionPoint ip) {
        return this.getOptionalValue(ip);
    }

    public <T extends JsonValue> T getValue(InjectionPoint ip) {
        CDILogging.log.jsonValueProducer(ip);
        return (T)this.util.generalJsonValueProducer(ip);
    }

    public <T extends JsonValue> Optional<T> getOptionalValue(InjectionPoint ip) {
        CDILogging.log.jsonValueProducer(ip);
        JsonValue jsonValue = this.util.generalJsonValueProducer(ip);
        return Optional.ofNullable(jsonValue);
    }
}

