/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LogAggregationContext;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class ApplicationSubmissionContext {
    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static ApplicationSubmissionContext newInstance(ApplicationId applicationId, String applicationName, String queue, Priority priority, ContainerLaunchContext amContainer, boolean isUnmanagedAM, boolean cancelTokensWhenComplete, int maxAppAttempts, Resource resource, String applicationType, boolean keepContainers, String appLabelExpression, String amContainerLabelExpression) {
        ApplicationSubmissionContext context = Records.newRecord(ApplicationSubmissionContext.class);
        context.setApplicationId(applicationId);
        context.setApplicationName(applicationName);
        context.setQueue(queue);
        context.setPriority(priority);
        context.setAMContainerSpec(amContainer);
        context.setUnmanagedAM(isUnmanagedAM);
        context.setCancelTokensWhenComplete(cancelTokensWhenComplete);
        context.setMaxAppAttempts(maxAppAttempts);
        context.setApplicationType(applicationType);
        context.setKeepContainersAcrossApplicationAttempts(keepContainers);
        context.setNodeLabelExpression(appLabelExpression);
        context.setResource(resource);
        ResourceRequest amReq = Records.newRecord(ResourceRequest.class);
        amReq.setResourceName("*");
        amReq.setCapability(resource);
        amReq.setNumContainers(1);
        amReq.setRelaxLocality(true);
        amReq.setNodeLabelExpression(amContainerLabelExpression);
        context.setAMContainerResourceRequest(amReq);
        return context;
    }

    public static ApplicationSubmissionContext newInstance(ApplicationId applicationId, String applicationName, String queue, Priority priority, ContainerLaunchContext amContainer, boolean isUnmanagedAM, boolean cancelTokensWhenComplete, int maxAppAttempts, Resource resource, String applicationType, boolean keepContainers) {
        return ApplicationSubmissionContext.newInstance(applicationId, applicationName, queue, priority, amContainer, isUnmanagedAM, cancelTokensWhenComplete, maxAppAttempts, resource, applicationType, keepContainers, null, null);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static ApplicationSubmissionContext newInstance(ApplicationId applicationId, String applicationName, String queue, Priority priority, ContainerLaunchContext amContainer, boolean isUnmanagedAM, boolean cancelTokensWhenComplete, int maxAppAttempts, Resource resource, String applicationType) {
        return ApplicationSubmissionContext.newInstance(applicationId, applicationName, queue, priority, amContainer, isUnmanagedAM, cancelTokensWhenComplete, maxAppAttempts, resource, applicationType, false, null, null);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static ApplicationSubmissionContext newInstance(ApplicationId applicationId, String applicationName, String queue, Priority priority, ContainerLaunchContext amContainer, boolean isUnmanagedAM, boolean cancelTokensWhenComplete, int maxAppAttempts, Resource resource) {
        return ApplicationSubmissionContext.newInstance(applicationId, applicationName, queue, priority, amContainer, isUnmanagedAM, cancelTokensWhenComplete, maxAppAttempts, resource, null);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static ApplicationSubmissionContext newInstance(ApplicationId applicationId, String applicationName, String queue, ContainerLaunchContext amContainer, boolean isUnmanagedAM, boolean cancelTokensWhenComplete, int maxAppAttempts, String applicationType, boolean keepContainers, String appLabelExpression, ResourceRequest resourceRequest) {
        ApplicationSubmissionContext context = Records.newRecord(ApplicationSubmissionContext.class);
        context.setApplicationId(applicationId);
        context.setApplicationName(applicationName);
        context.setQueue(queue);
        context.setAMContainerSpec(amContainer);
        context.setUnmanagedAM(isUnmanagedAM);
        context.setCancelTokensWhenComplete(cancelTokensWhenComplete);
        context.setMaxAppAttempts(maxAppAttempts);
        context.setApplicationType(applicationType);
        context.setKeepContainersAcrossApplicationAttempts(keepContainers);
        context.setNodeLabelExpression(appLabelExpression);
        context.setAMContainerResourceRequest(resourceRequest);
        return context;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static ApplicationSubmissionContext newInstance(ApplicationId applicationId, String applicationName, String queue, Priority priority, ContainerLaunchContext amContainer, boolean isUnmanagedAM, boolean cancelTokensWhenComplete, int maxAppAttempts, Resource resource, String applicationType, boolean keepContainers, long attemptFailuresValidityInterval) {
        ApplicationSubmissionContext context = ApplicationSubmissionContext.newInstance(applicationId, applicationName, queue, priority, amContainer, isUnmanagedAM, cancelTokensWhenComplete, maxAppAttempts, resource, applicationType, keepContainers);
        context.setAttemptFailuresValidityInterval(attemptFailuresValidityInterval);
        return context;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static ApplicationSubmissionContext newInstance(ApplicationId applicationId, String applicationName, String queue, Priority priority, ContainerLaunchContext amContainer, boolean isUnmanagedAM, boolean cancelTokensWhenComplete, int maxAppAttempts, Resource resource, String applicationType, boolean keepContainers, LogAggregationContext logAggregationContext) {
        ApplicationSubmissionContext context = ApplicationSubmissionContext.newInstance(applicationId, applicationName, queue, priority, amContainer, isUnmanagedAM, cancelTokensWhenComplete, maxAppAttempts, resource, applicationType, keepContainers);
        context.setLogAggregationContext(logAggregationContext);
        return context;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract ApplicationId getApplicationId();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setApplicationId(ApplicationId var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getApplicationName();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setApplicationName(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getQueue();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setQueue(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Priority getPriority();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setPriority(Priority var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract ContainerLaunchContext getAMContainerSpec();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setAMContainerSpec(ContainerLaunchContext var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract boolean getUnmanagedAM();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setUnmanagedAM(boolean var1);

    @InterfaceAudience.LimitedPrivate(value={"mapreduce"})
    @InterfaceStability.Unstable
    public abstract boolean getCancelTokensWhenComplete();

    @InterfaceAudience.LimitedPrivate(value={"mapreduce"})
    @InterfaceStability.Unstable
    public abstract void setCancelTokensWhenComplete(boolean var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract int getMaxAppAttempts();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setMaxAppAttempts(int var1);

    @InterfaceAudience.Public
    public abstract Resource getResource();

    @InterfaceAudience.Public
    public abstract void setResource(Resource var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getApplicationType();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setApplicationType(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract boolean getKeepContainersAcrossApplicationAttempts();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setKeepContainersAcrossApplicationAttempts(boolean var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Set<String> getApplicationTags();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setApplicationTags(Set<String> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public abstract String getNodeLabelExpression();

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public abstract void setNodeLabelExpression(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public abstract ResourceRequest getAMContainerResourceRequest();

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public abstract void setAMContainerResourceRequest(ResourceRequest var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract long getAttemptFailuresValidityInterval();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setAttemptFailuresValidityInterval(long var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract LogAggregationContext getLogAggregationContext();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setLogAggregationContext(LogAggregationContext var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract ReservationId getReservationID();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setReservationID(ReservationId var1);
}

