/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.thriftserver.session;

import java.util.ArrayList;
import java.util.List;
import org.apache.livy.thriftserver.session.DataType;
import org.apache.livy.thriftserver.session.SparkCatalogJob;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.GenericRow;
import scala.collection.JavaConversions;
import scala.collection.Seq;

public class GetTablesJob
extends SparkCatalogJob {
    private final String databasePattern;
    private final String tablePattern;
    private final List<String> tableTypes = new ArrayList<String>();

    public GetTablesJob(String databasePattern, String tablePattern, List<String> tableTypes, String sessionId, String jobId, DataType[] resultTypes) {
        super(sessionId, jobId, resultTypes);
        this.databasePattern = this.convertSchemaPattern(databasePattern);
        this.tablePattern = this.convertIdentifierPattern(tablePattern, true);
        if (tableTypes != null) {
            for (String type : tableTypes) {
                this.tableTypes.add(type.toUpperCase());
            }
        }
    }

    @Override
    protected List<Row> fetchCatalogObjects(SessionCatalog catalog) {
        ArrayList<Row> tableList = new ArrayList<Row>();
        List databases = JavaConversions.seqAsJavaList((Seq)catalog.listDatabases(this.databasePattern));
        for (String db : databases) {
            List tableIdentifiers = JavaConversions.seqAsJavaList((Seq)catalog.listTables(db, this.tablePattern));
            for (TableIdentifier tableIdentifier : tableIdentifiers) {
                CatalogTable table = catalog.getTempViewOrPermanentTableMetadata(tableIdentifier);
                String type = this.convertTableType(table.tableType().name());
                if (!this.tableTypes.isEmpty() && !this.tableTypes.contains(type)) continue;
                tableList.add((Row)new GenericRow(new Object[]{"", table.database(), table.identifier().table(), type, table.comment().isDefined() ? table.comment().get() : ""}));
            }
        }
        return tableList;
    }

    private String convertTableType(String originalType) {
        if (originalType.equals(CatalogTableType.MANAGED().name())) {
            return ClassicTableTypes.TABLE.name();
        }
        if (originalType.equals(CatalogTableType.EXTERNAL().name())) {
            return ClassicTableTypes.TABLE.name();
        }
        if (originalType.equals(CatalogTableType.VIEW().name())) {
            return ClassicTableTypes.VIEW.name();
        }
        throw new IllegalArgumentException("Invalid spark table type " + originalType);
    }

    private static enum ClassicTableTypes {
        TABLE,
        VIEW;

    }
}

