/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.imps;

import java.util.concurrent.Executor;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.CuratorEvent;
import org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.zookeeper.KeeperException;

class Backgrounding {
    private final boolean inBackground;
    private final Object context;
    private final BackgroundCallback callback;

    Backgrounding(Object context) {
        this.inBackground = true;
        this.context = context;
        this.callback = null;
    }

    Backgrounding(BackgroundCallback callback) {
        this.inBackground = true;
        this.context = null;
        this.callback = callback;
    }

    Backgrounding(boolean inBackground) {
        this.inBackground = inBackground;
        this.context = null;
        this.callback = null;
    }

    Backgrounding(BackgroundCallback callback, Object context) {
        this.inBackground = true;
        this.context = context;
        this.callback = callback;
    }

    Backgrounding(CuratorFrameworkImpl client, BackgroundCallback callback, Object context, Executor executor) {
        this(Backgrounding.wrapCallback(client, callback, executor), context);
    }

    Backgrounding(CuratorFrameworkImpl client, BackgroundCallback callback, Executor executor) {
        this(Backgrounding.wrapCallback(client, callback, executor));
    }

    Backgrounding() {
        this.inBackground = false;
        this.context = null;
        this.callback = null;
    }

    boolean inBackground() {
        return this.inBackground;
    }

    Object getContext() {
        return this.context;
    }

    BackgroundCallback getCallback() {
        return this.callback;
    }

    private static BackgroundCallback wrapCallback(final CuratorFrameworkImpl client, final BackgroundCallback callback, final Executor executor) {
        return new BackgroundCallback(){

            @Override
            public void processResult(CuratorFramework dummy, final CuratorEvent event) throws Exception {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            callback.processResult(client, event);
                        }
                        catch (Exception e) {
                            if (e instanceof KeeperException) {
                                client.validateConnection(client.codeToState(((KeeperException)e).code()));
                            }
                            client.logError("Background operation result handling threw exception", e);
                        }
                    }
                });
            }
        };
    }
}

