/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RpcMultiplexer;

public class WeightedRoundRobinMultiplexer
implements RpcMultiplexer {
    public static final String IPC_CALLQUEUE_WRRMUX_WEIGHTS_KEY = "faircallqueue.multiplexer.weights";
    public static final Log LOG = LogFactory.getLog(WeightedRoundRobinMultiplexer.class);
    private final int numQueues;
    private final AtomicInteger currentQueueIndex;
    private final AtomicInteger requestsLeft;
    private int[] queueWeights;

    public WeightedRoundRobinMultiplexer(int aNumQueues, String ns, Configuration conf) {
        if (aNumQueues <= 0) {
            throw new IllegalArgumentException("Requested queues (" + aNumQueues + ") must be greater than zero.");
        }
        this.numQueues = aNumQueues;
        this.queueWeights = conf.getInts(ns + "." + IPC_CALLQUEUE_WRRMUX_WEIGHTS_KEY);
        if (this.queueWeights.length == 0) {
            this.queueWeights = this.getDefaultQueueWeights(this.numQueues);
        } else if (this.queueWeights.length != this.numQueues) {
            throw new IllegalArgumentException(ns + "." + IPC_CALLQUEUE_WRRMUX_WEIGHTS_KEY + " must specify exactly " + this.numQueues + " weights: one for each priority level.");
        }
        this.currentQueueIndex = new AtomicInteger(0);
        this.requestsLeft = new AtomicInteger(this.queueWeights[0]);
        LOG.info((Object)"WeightedRoundRobinMultiplexer is being used.");
    }

    private int[] getDefaultQueueWeights(int aNumQueues) {
        int[] weights = new int[aNumQueues];
        int weight = 1;
        for (int i = aNumQueues - 1; i >= 0; --i) {
            weights[i] = weight;
            weight *= 2;
        }
        return weights;
    }

    private void moveToNextQueue() {
        int thisIdx = this.currentQueueIndex.get();
        int nextIdx = (thisIdx + 1) % this.numQueues;
        this.currentQueueIndex.set(nextIdx);
        this.requestsLeft.set(this.queueWeights[nextIdx]);
    }

    private void advanceIndex() {
        int requestsLeftVal = this.requestsLeft.decrementAndGet();
        if (requestsLeftVal == 0) {
            this.moveToNextQueue();
        }
    }

    private int getCurrentIndex() {
        return this.currentQueueIndex.get();
    }

    @Override
    public int getAndAdvanceCurrentIndex() {
        int idx = this.getCurrentIndex();
        this.advanceIndex();
        return idx;
    }
}

