/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.algorithm.community.kcore;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.apache.hugegraph.computer.algorithm.community.kcore.KcoreValue;
import org.apache.hugegraph.computer.core.combiner.Combiner;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.graph.id.Id;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.graph.vertex.Vertex;
import org.apache.hugegraph.computer.core.worker.Computation;
import org.apache.hugegraph.computer.core.worker.ComputationContext;

public class Kcore
implements Computation<Id> {
    public static final String OPTION_K = "kcore.k";
    public static final int K_DEFAULT_VALUE = 3;
    private final KcoreValue initValue = new KcoreValue();
    private int k = 0;

    public String name() {
        return "kcore";
    }

    public String category() {
        return "community";
    }

    public void init(Config config) {
        this.k = config.getInt(OPTION_K, 3);
    }

    public void compute0(ComputationContext context, Vertex vertex) {
        KcoreValue value = this.initValue;
        value.core((Id)vertex.id().copy());
        vertex.value((Value)value);
        if (vertex.numEdges() < this.k) {
            value.degree(0);
            context.sendMessageToAllEdges(vertex, (Value)vertex.id());
            vertex.inactivate();
        } else {
            value.degree(vertex.numEdges());
            assert (vertex.active());
        }
    }

    public void compute(ComputationContext context, Vertex vertex, Iterator<Id> messages) {
        KcoreValue value = (KcoreValue)vertex.value();
        if (!value.active()) {
            vertex.inactivate();
            return;
        }
        int superstep = context.superstep();
        if (superstep <= 2) {
            int deleted = Iterators.size(messages);
            assert (value.active());
            if (value.decreaseDegree(deleted) < this.k) {
                value.degree(0);
                if (superstep == 1) {
                    context.sendMessageToAllEdges(vertex, (Value)vertex.id());
                }
                vertex.inactivate();
            } else if (superstep == 2) {
                context.sendMessageToAllEdgesIf(vertex, (Value)vertex.id(), (source, target) -> source.compareTo(target) < 0);
                vertex.inactivate();
            } else {
                assert (superstep == 1);
                assert (vertex.active());
            }
        } else {
            assert (superstep > 2);
            Id message = (Id)Combiner.combineAll((Combiner)context.combiner(), messages);
            if (value.core().compareTo((Object)message) > 0) {
                value.core(message);
                context.sendMessageToAllEdges(vertex, (Value)message);
            }
            vertex.inactivate();
        }
    }
}

