/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.sort.flusher;

import java.io.IOException;
import org.apache.hugegraph.computer.core.combiner.PointerCombiner;
import org.apache.hugegraph.computer.core.io.BytesInput;
import org.apache.hugegraph.computer.core.io.BytesOutput;
import org.apache.hugegraph.computer.core.io.IOFactory;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.io.RandomAccessOutput;
import org.apache.hugegraph.computer.core.sort.flusher.OuterSortFlusher;
import org.apache.hugegraph.computer.core.sort.flusher.PeekableIterator;
import org.apache.hugegraph.computer.core.sort.flusher.PeekableIteratorAdaptor;
import org.apache.hugegraph.computer.core.sort.sorter.SubKvSorter;
import org.apache.hugegraph.computer.core.store.EntryIterator;
import org.apache.hugegraph.computer.core.store.KvEntryFileWriter;
import org.apache.hugegraph.computer.core.store.entry.EntriesUtil;
import org.apache.hugegraph.computer.core.store.entry.KvEntry;
import org.apache.hugegraph.computer.core.store.entry.Pointer;
import org.apache.hugegraph.util.E;

public class CombineSubKvOuterSortFlusher
implements OuterSortFlusher {
    private final PointerCombiner combiner;
    private final BytesOutput output;
    private final int subKvFlushThreshold;
    private int sources;

    public CombineSubKvOuterSortFlusher(PointerCombiner combiner, int subKvFlushThreshold) {
        this.combiner = combiner;
        this.output = IOFactory.createBytesOutput(8192);
        this.subKvFlushThreshold = subKvFlushThreshold;
    }

    @Override
    public void sources(int sources) {
        this.sources = sources;
    }

    @Override
    public void flush(EntryIterator entries, KvEntryFileWriter writer) throws IOException {
        E.checkArgument((boolean)entries.hasNext(), (String)"Parameter entries can't be empty", (Object[])new Object[0]);
        PeekableIterator<KvEntry> kvEntries = PeekableIteratorAdaptor.of(entries);
        SubKvSorter sorter = new SubKvSorter(kvEntries, this.sources);
        KvEntry currentKv = sorter.currentKv();
        do {
            currentKv.key().write((RandomAccessOutput)this.output);
            long position = this.output.position();
            this.output.writeFixedInt(0);
            this.output.writeFixedInt(0);
            int writtenCount = 0;
            KvEntry lastSubKv = sorter.next();
            Pointer lastSubValue = lastSubKv.value();
            while (true) {
                KvEntry current = null;
                if (sorter.hasNext() && lastSubKv.compareTo(current = sorter.next()) == 0) {
                    lastSubValue = this.combiner.combine(lastSubValue, current.value());
                    continue;
                }
                lastSubKv.key().write((RandomAccessOutput)this.output);
                lastSubValue.write((RandomAccessOutput)this.output);
                if (current == null || ++writtenCount == this.subKvFlushThreshold) {
                    long currentPosition = this.output.position();
                    this.output.seek(position);
                    this.output.writeFixedInt((int)(currentPosition - position - 4L));
                    this.output.writeFixedInt(writtenCount);
                    this.output.seek(currentPosition);
                    BytesInput input = EntriesUtil.inputFromOutput(this.output);
                    writer.write(EntriesUtil.kvEntryFromInput((RandomAccessInput)input, true, true));
                    this.output.seek(0L);
                    if (current == null) break;
                    currentKv.key().write((RandomAccessOutput)this.output);
                    position = this.output.position();
                    this.output.writeFixedInt(0);
                    this.output.writeFixedInt(0);
                    writtenCount = 0;
                }
                lastSubKv = current;
                lastSubValue = lastSubKv.value();
            }
            sorter.reset();
        } while ((currentKv = sorter.currentKv()) != null);
        writer.finish();
    }
}

