/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.network.message;

import io.netty.buffer.ByteBuf;
import org.apache.hugegraph.computer.core.common.SerialEnum;

public final class MessageType
extends Enum<MessageType>
implements SerialEnum {
    public static final /* enum */ MessageType MSG = new MessageType(1, Category.DATA);
    public static final /* enum */ MessageType VERTEX = new MessageType(2, Category.DATA);
    public static final /* enum */ MessageType EDGE = new MessageType(3, Category.DATA);
    public static final /* enum */ MessageType ACK = new MessageType(128, Category.CONTROL);
    public static final /* enum */ MessageType FAIL = new MessageType(129, Category.CONTROL);
    public static final /* enum */ MessageType START = new MessageType(130, Category.CONTROL);
    public static final /* enum */ MessageType FINISH = new MessageType(131, Category.CONTROL);
    public static final /* enum */ MessageType PING = new MessageType(132, Category.CONTROL);
    public static final /* enum */ MessageType PONG = new MessageType(133, Category.CONTROL);
    public static final /* enum */ MessageType PAUSE_RECV = new MessageType(134, Category.CONTROL);
    public static final /* enum */ MessageType RESUME_RECV = new MessageType(135, Category.CONTROL);
    private final byte code;
    private final Category category;
    private static final /* synthetic */ MessageType[] $VALUES;

    public static MessageType[] values() {
        return (MessageType[])$VALUES.clone();
    }

    public static MessageType valueOf(String name) {
        return Enum.valueOf(MessageType.class, name);
    }

    private MessageType(int code, Category category) {
        assert (code >= 0 && code <= 255);
        this.code = (byte)code;
        this.category = category;
    }

    public byte code() {
        return this.code;
    }

    public Category category() {
        return this.category;
    }

    public static MessageType decode(ByteBuf buf) {
        byte code = buf.readByte();
        return (MessageType)SerialEnum.fromCode(MessageType.class, (byte)code);
    }

    static {
        $VALUES = new MessageType[]{MSG, VERTEX, EDGE, ACK, FAIL, START, FINISH, PING, PONG, PAUSE_RECV, RESUME_RECV};
        SerialEnum.register(MessageType.class);
    }

    public static enum Category {
        DATA,
        CONTROL;

    }
}

