/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.io;

import java.io.IOException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.io.RandomAccessOutput;
import org.apache.hugegraph.computer.core.io.UnsafeBytesInput;
import org.apache.hugegraph.computer.core.util.StringEncoding;
import org.apache.hugegraph.testutil.Whitebox;

public class StructRandomAccessOutput
implements RandomAccessOutput {
    private final RandomAccessOutput output;

    public StructRandomAccessOutput(RandomAccessOutput output) {
        this.output = output;
    }

    public long position() {
        return this.output.position();
    }

    public void seek(long position) throws IOException {
        this.output.seek(position);
    }

    public long skip(long n) throws IOException {
        return this.output.skip(n);
    }

    public void write(RandomAccessInput input, long offset, long length) throws IOException {
        if (UnsafeBytesInput.class == input.getClass()) {
            byte[] buffer = (byte[])Whitebox.getInternalState((Object)input, (String)"buffer");
            this.write(buffer, (int)offset, (int)length);
        } else {
            input.seek(offset);
            byte[] bytes = input.readBytes((int)length);
            this.write(bytes);
        }
    }

    public void write(int b) throws IOException {
        this.writeNumber(b);
    }

    public void write(byte[] b) throws IOException {
        this.writeString(StringEncoding.encodeBase64(b));
    }

    public void write(byte[] b, int off, int len) throws IOException {
        byte[] dest = new byte[len];
        System.arraycopy(b, off, dest, 0, len);
        this.writeString(StringEncoding.encodeBase64(dest));
    }

    public void writeBoolean(boolean v) throws IOException {
        this.writeRawString(v ? "true" : "false");
    }

    public void writeByte(int v) throws IOException {
        this.writeNumber(v);
    }

    public void writeShort(int v) throws IOException {
        this.writeNumber(v);
    }

    public void writeChar(int v) throws IOException {
        this.writeNumber(v);
    }

    public void writeInt(int v) throws IOException {
        this.writeNumber(v);
    }

    public void writeLong(long v) throws IOException {
        this.writeNumber(v);
    }

    public void writeFloat(float v) throws IOException {
        this.writeNumber(Float.valueOf(v));
    }

    public void writeDouble(double v) throws IOException {
        this.writeNumber(v);
    }

    public void writeBytes(String s) throws IOException {
        this.writeString(s);
    }

    public void writeChars(String s) throws IOException {
        this.writeString(s);
    }

    public void writeUTF(String s) throws IOException {
        this.writeString(s);
    }

    public void writeFixedInt(int v) throws IOException {
        this.writeInt(v);
    }

    public void writeFixedInt(long position, int v) throws IOException {
        long oldPosition = this.position();
        this.seek(position);
        this.writeInt(v);
        this.seek(oldPosition);
    }

    public void close() throws IOException {
        this.output.close();
    }

    protected void writeNumber(Number number) throws IOException {
        this.output.writeBytes(number.toString());
    }

    protected void writeRawString(String s) throws IOException {
        this.output.writeBytes(s);
    }

    protected void writeString(String s) throws IOException {
        this.output.writeBytes("\"");
        this.output.writeBytes(StringEscapeUtils.escapeJson((String)s));
        this.output.writeBytes("\"");
    }
}

