/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.graph;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.hugegraph.computer.core.graph.partition.PartitionStat;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.io.RandomAccessOutput;
import org.apache.hugegraph.computer.core.io.Readable;
import org.apache.hugegraph.computer.core.io.Writable;
import org.apache.hugegraph.computer.core.util.JsonUtil;
import org.apache.hugegraph.computer.core.worker.WorkerStat;
import org.apache.hugegraph.util.E;

public class SuperstepStat
implements Readable,
Writable {
    private long vertexCount;
    private long edgeCount;
    private long finishedVertexCount;
    private long messageSendCount;
    private long messageSendBytes;
    private long messageRecvCount;
    private long messageRecvBytes;
    private boolean active = true;

    public void increase(PartitionStat partitionStat) {
        E.checkArgumentNotNull((Object)partitionStat, (String)"The partitionStat can't be null", (Object[])new Object[0]);
        this.vertexCount += partitionStat.vertexCount();
        this.edgeCount += partitionStat.edgeCount();
        this.finishedVertexCount += partitionStat.finishedVertexCount();
        this.messageSendCount += partitionStat.messageSendCount();
        this.messageSendBytes += partitionStat.messageSendBytes();
        this.messageRecvCount += partitionStat.messageRecvCount();
        this.messageRecvBytes += partitionStat.messageRecvBytes();
    }

    public void increase(WorkerStat workerStat) {
        E.checkArgumentNotNull((Object)workerStat, (String)"The workerStat can't be null", (Object[])new Object[0]);
        for (PartitionStat partitionStat : workerStat) {
            this.increase(partitionStat);
        }
    }

    public long vertexCount() {
        return this.vertexCount;
    }

    public long edgeCount() {
        return this.edgeCount;
    }

    public long finishedVertexCount() {
        return this.finishedVertexCount;
    }

    public long messageSendCount() {
        return this.messageSendCount;
    }

    public long messageSendBytes() {
        return this.messageSendBytes;
    }

    public long messageRecvCount() {
        return this.messageRecvCount;
    }

    public long messageRecvBytes() {
        return this.messageRecvBytes;
    }

    public void inactivate() {
        this.active = false;
    }

    public boolean active() {
        return this.active;
    }

    public void read(RandomAccessInput in) throws IOException {
        this.vertexCount = in.readLong();
        this.edgeCount = in.readLong();
        this.finishedVertexCount = in.readLong();
        this.messageSendCount = in.readLong();
        this.messageSendBytes = in.readLong();
        this.messageRecvCount = in.readLong();
        this.messageRecvBytes = in.readLong();
        this.active = in.readBoolean();
    }

    public void write(RandomAccessOutput out) throws IOException {
        out.writeLong(this.vertexCount);
        out.writeLong(this.edgeCount);
        out.writeLong(this.finishedVertexCount);
        out.writeLong(this.messageSendCount);
        out.writeLong(this.messageSendBytes);
        out.writeLong(this.messageRecvCount);
        out.writeLong(this.messageRecvBytes);
        out.writeBoolean(this.active);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SuperstepStat)) {
            return false;
        }
        SuperstepStat other = (SuperstepStat)obj;
        return this.vertexCount == other.vertexCount && this.edgeCount == other.edgeCount && this.finishedVertexCount == other.finishedVertexCount && this.messageSendCount == other.messageSendCount && this.messageSendBytes == other.messageSendBytes && this.messageRecvCount == other.messageRecvCount && this.messageRecvBytes == other.messageRecvBytes && this.active == other.active;
    }

    public int hashCode() {
        return Objects.hash(this.vertexCount, this.edgeCount, this.finishedVertexCount, this.messageSendCount, this.messageSendBytes, this.messageRecvCount, this.messageRecvBytes, this.active);
    }

    public String toString() {
        return JsonUtil.toJsonWithClass(this);
    }

    public static SuperstepStat from(List<WorkerStat> workerStats) {
        SuperstepStat superstepStat = new SuperstepStat();
        for (WorkerStat workerStat : workerStats) {
            superstepStat.increase(workerStat);
        }
        return superstepStat;
    }
}

