/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data;

import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.logging.Logger;
import com.clickhouse.logging.LoggerFactory;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ClickHouseThreadFactory
implements ThreadFactory {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseThreadFactory.class);
    private static final Thread.UncaughtExceptionHandler hanlder = (t, e) -> log.warn((Object)("Uncaught exception from thread: " + t), e);
    private final boolean daemon;
    private final int priority;
    private final ThreadGroup group;
    private final String namePrefix;
    private final AtomicInteger threadNumber;

    public ClickHouseThreadFactory(Object owner) {
        this(owner, true, 5);
    }

    public ClickHouseThreadFactory(Object owner, boolean daemon, int priority) {
        String prefix = null;
        if (owner instanceof String) {
            prefix = ((String)owner).trim();
        } else if (owner != null) {
            prefix = owner.getClass().getSimpleName() + '@' + owner.hashCode();
        }
        this.daemon = daemon;
        this.priority = ClickHouseChecker.between(priority, "Priority", 1, 10);
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = !ClickHouseChecker.isNullOrBlank(prefix) ? prefix : this.getClass().getSimpleName() + '@' + this.hashCode() + '-';
        this.threadNumber = new AtomicInteger(1);
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        if (this.daemon != t.isDaemon()) {
            t.setDaemon(this.daemon);
        }
        if (this.priority != t.getPriority()) {
            t.setPriority(this.priority);
        }
        t.setUncaughtExceptionHandler(hanlder);
        return t;
    }
}

