/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.lookup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;

public final class LookupResult {
    private final List<Record> records;
    private final List<Name> aliases;
    private final Map<Record, Message> queryResponsePairs;
    private final boolean isAuthenticated;

    @Deprecated
    public LookupResult(List<Record> records, List<Name> aliases) {
        this.records = Collections.unmodifiableList(new ArrayList<Record>(records));
        this.aliases = aliases == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<Name>(aliases));
        this.queryResponsePairs = Collections.emptyMap();
        this.isAuthenticated = false;
    }

    LookupResult(boolean isAuthenticated) {
        this.queryResponsePairs = Collections.emptyMap();
        this.isAuthenticated = isAuthenticated;
        this.records = Collections.emptyList();
        this.aliases = Collections.emptyList();
    }

    LookupResult(Record query, boolean isAuthenticated, Record record) {
        this.queryResponsePairs = Collections.singletonMap(query, null);
        this.isAuthenticated = isAuthenticated;
        this.records = Collections.singletonList(record);
        this.aliases = Collections.emptyList();
    }

    LookupResult(LookupResult previous, Record query, Message answer, boolean isAuthenticated, List<Record> records, List<Name> aliases) {
        HashMap<Record, Message> map = new HashMap<Record, Message>(previous.queryResponsePairs.size() + 1);
        map.putAll(previous.queryResponsePairs);
        map.put(query, answer);
        this.queryResponsePairs = Collections.unmodifiableMap(map);
        this.isAuthenticated = previous.isAuthenticated && isAuthenticated && this.queryResponsePairs.values().stream().filter(Objects::nonNull).allMatch(a -> a.getHeader().getFlag(10));
        this.records = Collections.unmodifiableList(new ArrayList<Record>(records));
        this.aliases = Collections.unmodifiableList(new ArrayList<Name>(aliases));
    }

    @Generated
    public List<Record> getRecords() {
        return this.records;
    }

    @Generated
    public List<Name> getAliases() {
        return this.aliases;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LookupResult)) {
            return false;
        }
        LookupResult other = (LookupResult)o;
        if (this.isAuthenticated() != other.isAuthenticated()) {
            return false;
        }
        List<Record> this$records = this.getRecords();
        List<Record> other$records = other.getRecords();
        if (this$records == null ? other$records != null : !((Object)this$records).equals(other$records)) {
            return false;
        }
        List<Name> this$aliases = this.getAliases();
        List<Name> other$aliases = other.getAliases();
        if (this$aliases == null ? other$aliases != null : !((Object)this$aliases).equals(other$aliases)) {
            return false;
        }
        Map<Record, Message> this$queryResponsePairs = this.getQueryResponsePairs();
        Map<Record, Message> other$queryResponsePairs = other.getQueryResponsePairs();
        return !(this$queryResponsePairs == null ? other$queryResponsePairs != null : !((Object)this$queryResponsePairs).equals(other$queryResponsePairs));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAuthenticated() ? 79 : 97);
        List<Record> $records = this.getRecords();
        result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
        List<Name> $aliases = this.getAliases();
        result = result * 59 + ($aliases == null ? 43 : ((Object)$aliases).hashCode());
        Map<Record, Message> $queryResponsePairs = this.getQueryResponsePairs();
        result = result * 59 + ($queryResponsePairs == null ? 43 : ((Object)$queryResponsePairs).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LookupResult(records=" + this.getRecords() + ", aliases=" + this.getAliases() + ", queryResponsePairs=" + this.getQueryResponsePairs() + ", isAuthenticated=" + this.isAuthenticated() + ")";
    }

    @Generated
    Map<Record, Message> getQueryResponsePairs() {
        return this.queryResponsePairs;
    }

    @Generated
    boolean isAuthenticated() {
        return this.isAuthenticated;
    }
}

