/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport.tls;

import java.io.Serializable;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Properties;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;
import org.snmp4j.transport.tls.TLSTMUtil;
import org.snmp4j.transport.tls.TlsTmSecurityCallback;

public class PropertiesTlsTmSecurityCallback
implements TlsTmSecurityCallback<X509Certificate> {
    private static final LogAdapter LOGGER = LogFactory.getLogger(PropertiesTlsTmSecurityCallback.class);
    private final boolean serverMode;
    private final Properties properties;

    public PropertiesTlsTmSecurityCallback(boolean serverMode) {
        this(System.getProperties(), serverMode);
    }

    public PropertiesTlsTmSecurityCallback(Properties properties, boolean serverMode) {
        this.serverMode = serverMode;
        if (properties == null) {
            throw new NullPointerException();
        }
        this.properties = properties;
    }

    public OctetString getSecurityName(X509Certificate[] peerCertificateChain) {
        String securityName = this.properties.getProperty("org.snmp4j.arg.securityName", null);
        if (securityName != null) {
            return new OctetString(securityName);
        }
        return null;
    }

    @Override
    public boolean isClientCertificateAccepted(X509Certificate peerEndCertificate) throws CertificateException {
        String accepted = this.properties.getProperty("org.snmp4j.arg.tlsLocalID", "");
        if (this.serverMode) {
            accepted = this.properties.getProperty("org.snmp4j.arg.tlsPeerID", "");
        }
        if (peerEndCertificate != null && peerEndCertificate.getSubjectX500Principal().getName().equals(accepted)) {
            return true;
        }
        if (accepted.length() == 0) {
            return false;
        }
        String errmsg = "Certificate " + peerEndCertificate + " rejected because subject DN does not match " + accepted;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Serializable)((Object)errmsg));
        }
        throw new CertificateException(errmsg);
    }

    public boolean isServerCertificateAccepted(X509Certificate[] peerCertificateChain) throws CertificateException {
        String subject;
        if (peerCertificateChain == null || peerCertificateChain.length == 0) {
            throw new CertificateException("Server certificate chain is empty");
        }
        String fingerprint = this.properties.getProperty("org.snmp4j.arg.tlsCertFingerprint", "");
        if (fingerprint.length() > 0) {
            OctetString acceptedFingerprint = OctetString.fromHexString(fingerprint);
            int accepted = -1;
            for (X509Certificate cert : peerCertificateChain) {
                OctetString certFingerprint = TLSTMUtil.getFingerprint(cert);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Serializable)((Object)("Matching server fingerprint " + certFingerprint + " against accepted " + fingerprint)));
                }
                if (certFingerprint != null && certFingerprint.equals(acceptedFingerprint)) {
                    accepted = 1;
                    break;
                }
                accepted = 0;
            }
            if (accepted <= 0) {
                throw new CertificateException("Server certificate chain " + Arrays.asList(peerCertificateChain) + " does not match accepted fingerprint " + acceptedFingerprint);
            }
        }
        String acceptedPeer = this.properties.getProperty("org.snmp4j.arg.tlsPeerID", "");
        if (this.serverMode) {
            acceptedPeer = this.properties.getProperty("org.snmp4j.arg.tlsLocalID", "");
        }
        if ((subject = peerCertificateChain[0].getSubjectX500Principal().getName()).equals(acceptedPeer)) {
            return true;
        }
        if (acceptedPeer.length() > 0) {
            throw new CertificateException("Certificate subject '" + subject + "' does not match accepted peer '" + acceptedPeer + "'");
        }
        String acceptedCA = this.properties.getProperty("org.snmp4j.arg.tlsTrustCA", "");
        if (acceptedCA.length() == 0) {
            return false;
        }
        for (int i = 1; i < peerCertificateChain.length; ++i) {
            String ca = peerCertificateChain[i].getIssuerX500Principal().getName();
            if (ca.equals(acceptedCA)) {
                return true;
            }
            LOGGER.debug((Serializable)((Object)("Certification authority '" + ca + "' does not match accepted CA '" + acceptedCA + "'")));
        }
        throw new CertificateException("Certification authorities for certificate chain " + Arrays.asList(peerCertificateChain) + " does not match accepted CA '" + acceptedCA + "'");
    }

    @Override
    public boolean isAcceptedIssuer(X509Certificate issuerCertificate) throws CertificateException {
        String acceptedCA = this.properties.getProperty("org.snmp4j.arg.tlsTrustCA", "");
        if (acceptedCA.length() == 0) {
            return false;
        }
        if (issuerCertificate != null && issuerCertificate.getIssuerDN().getName().equals(acceptedCA)) {
            return true;
        }
        throw new CertificateException("Issuer certificate " + issuerCertificate + " does not have accepted DN: " + acceptedCA);
    }

    @Override
    public String getLocalCertificateAlias(Address targetAddress) {
        return this.properties.getProperty("org.snmp4j.arg.tlsLocalID");
    }
}

