/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.http;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.HttpProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.apache.hertzbeat.common.util.IpDomainUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class SslCertificateCollectImpl
extends AbstractCollect {
    private static final Logger log = LoggerFactory.getLogger(SslCertificateCollectImpl.class);
    private static final String NAME_SUBJECT = "subject";
    private static final String NAME_EXPIRED = "expired";
    private static final String NAME_START_TIME = "start_time";
    private static final String NAME_START_TIMESTAMP = "start_timestamp";
    private static final String NAME_END_TIME = "end_time";
    private static final String NAME_END_TIMESTAMP = "end_timestamp";

    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        if (metrics == null || metrics.getHttp() == null) {
            throw new IllegalArgumentException("Http/Https collect must has http params");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collect(CollectRep.MetricsData.Builder builder, Metrics metrics) {
        long startTime = System.currentTimeMillis();
        HttpProtocol httpProtocol = metrics.getHttp();
        String url = httpProtocol.getUrl();
        if (!StringUtils.hasText((String)url) || !url.startsWith("/")) {
            httpProtocol.setUrl((String)(StringUtils.hasText((String)url) ? "/" + url.trim() : "/"));
        }
        HttpURLConnection urlConnection = null;
        try {
            Object uri = "";
            uri = IpDomainUtil.isHasSchema((String)httpProtocol.getHost()) ? httpProtocol.getHost() + ":" + httpProtocol.getPort() : "https://" + httpProtocol.getHost() + ":" + httpProtocol.getPort();
            urlConnection = (HttpsURLConnection)new URL((String)uri).openConnection();
            boolean verifySsl = Boolean.parseBoolean(httpProtocol.getSsl());
            if (!verifySsl) {
                SSLContext ignoreSslContext = this.createIgnoreVerifySslContext();
                ((HttpsURLConnection)urlConnection).setSSLSocketFactory(ignoreSslContext.getSocketFactory());
            }
            urlConnection.connect();
            Certificate[] certificates = ((HttpsURLConnection)urlConnection).getServerCertificates();
            if (certificates == null || certificates.length == 0) {
                builder.setCode(CollectRep.Code.FAIL);
                builder.setMsg("Ssl certificate does not exist.");
                return;
            }
            long responseTime = System.currentTimeMillis() - startTime;
            for (Certificate certificate : ((HttpsURLConnection)urlConnection).getServerCertificates()) {
                X509Certificate x509Certificate = (X509Certificate)certificate;
                Date now = new Date();
                Date deadline = x509Certificate.getNotAfter();
                boolean expired = deadline != null && now.after(deadline);
                CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
                for (String alias : metrics.getAliasFields()) {
                    if ("responseTime".equalsIgnoreCase(alias)) {
                        valueRowBuilder.addColumn(Long.toString(responseTime));
                        continue;
                    }
                    if (NAME_SUBJECT.equalsIgnoreCase(alias)) {
                        valueRowBuilder.addColumn(x509Certificate.getSubjectX500Principal().getName());
                        continue;
                    }
                    if (NAME_EXPIRED.equalsIgnoreCase(alias)) {
                        valueRowBuilder.addColumn(Boolean.toString(expired));
                        continue;
                    }
                    if (NAME_START_TIME.equalsIgnoreCase(alias)) {
                        valueRowBuilder.addColumn(x509Certificate.getNotBefore().toLocaleString());
                        continue;
                    }
                    if (NAME_START_TIMESTAMP.equalsIgnoreCase(alias)) {
                        valueRowBuilder.addColumn(String.valueOf(x509Certificate.getNotBefore().getTime()));
                        continue;
                    }
                    if (NAME_END_TIME.equalsIgnoreCase(alias)) {
                        valueRowBuilder.addColumn(x509Certificate.getNotAfter().toLocaleString());
                        continue;
                    }
                    if (NAME_END_TIMESTAMP.equalsIgnoreCase(alias)) {
                        valueRowBuilder.addColumn(String.valueOf(x509Certificate.getNotAfter().getTime()));
                        continue;
                    }
                    valueRowBuilder.addColumn("&nbsp;");
                }
                builder.addValueRow(valueRowBuilder.build());
            }
        }
        catch (SSLPeerUnverifiedException e1) {
            String errorMsg = "Ssl certificate does not exist.";
            if (e1.getMessage() != null) {
                errorMsg = e1.getMessage();
                log.error(errorMsg);
            }
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(errorMsg);
        }
        catch (UnknownHostException e2) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e2);
            log.info(errorMsg);
            builder.setCode(CollectRep.Code.UN_REACHABLE);
            builder.setMsg("unknown host:" + errorMsg);
        }
        catch (InterruptedIOException | ConnectException | SSLException e3) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e3);
            log.info(errorMsg);
            builder.setCode(CollectRep.Code.UN_CONNECTABLE);
            builder.setMsg(errorMsg);
        }
        catch (IOException e4) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e4);
            log.info(errorMsg);
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(errorMsg);
        }
        catch (Exception e) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e);
            log.error(errorMsg, (Throwable)e);
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(errorMsg);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    public String supportProtocol() {
        return "ssl_cert";
    }

    private void validateParams(Metrics metrics) {
    }

    public SSLContext createIgnoreVerifySslContext() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sc = SSLContext.getInstance("TLS");
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        sc.init(null, new TrustManager[]{trustManager}, null);
        return sc;
    }
}

