/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.rpc;

import io.grpc.ManagedChannel;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ManagedChannelHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ManagedChannelHelper.class);

    public static boolean shutdownAndAwaitTermination(ManagedChannel mChannel) {
        return ManagedChannelHelper.shutdownAndAwaitTermination(mChannel, 1000L);
    }

    public static boolean shutdownAndAwaitTermination(ManagedChannel mChannel, long timeoutMillis) {
        if (mChannel == null) {
            return true;
        }
        mChannel.shutdown();
        TimeUnit unit = TimeUnit.MILLISECONDS;
        long phaseOne = timeoutMillis / 5L;
        try {
            if (mChannel.awaitTermination(phaseOne, unit)) {
                return true;
            }
            mChannel.shutdownNow();
            if (mChannel.awaitTermination(timeoutMillis - phaseOne, unit)) {
                return true;
            }
            LOG.warn("Fail to shutdown managed channel: {}.", (Object)mChannel);
        }
        catch (InterruptedException e) {
            mChannel.shutdownNow();
            Thread.currentThread().interrupt();
        }
        return false;
    }
}

