/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.resources;

import com.google.errorprone.annotations.MustBeClosed;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.instrumentation.resources.CgroupV1ContainerIdExtractor;
import io.opentelemetry.instrumentation.resources.CgroupV2ContainerIdExtractor;
import io.opentelemetry.sdk.resources.Resource;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ContainerResource {
    private static final AttributeKey<String> CONTAINER_ID = AttributeKey.stringKey((String)"container.id");
    static final Filesystem FILESYSTEM_INSTANCE = new Filesystem();
    private static final Resource INSTANCE = ContainerResource.buildSingleton();
    private final CgroupV1ContainerIdExtractor v1Extractor;
    private final CgroupV2ContainerIdExtractor v2Extractor;

    private static Resource buildSingleton() {
        return new ContainerResource().buildResource();
    }

    private ContainerResource() {
        this(new CgroupV1ContainerIdExtractor(), new CgroupV2ContainerIdExtractor());
    }

    ContainerResource(CgroupV1ContainerIdExtractor v1Extractor, CgroupV2ContainerIdExtractor v2Extractor) {
        this.v1Extractor = v1Extractor;
        this.v2Extractor = v2Extractor;
    }

    Resource buildResource() {
        String osName = System.getProperty("os.name");
        if (osName.equalsIgnoreCase("z/OS") || osName.equalsIgnoreCase("OS/390")) {
            return Resource.empty();
        }
        return this.getContainerId().map(id -> Resource.create((Attributes)Attributes.of(CONTAINER_ID, (Object)id))).orElseGet(Resource::empty);
    }

    private Optional<String> getContainerId() {
        Optional<String> v1Result = this.v1Extractor.extractContainerId();
        if (v1Result.isPresent()) {
            return v1Result;
        }
        return this.v2Extractor.extractContainerId();
    }

    public static Resource get() {
        return INSTANCE;
    }

    static class Filesystem {
        Filesystem() {
        }

        boolean isReadable(Path path) {
            return Files.isReadable(path);
        }

        @MustBeClosed
        Stream<String> lines(Path path) throws IOException {
            return Files.lines(path);
        }

        List<String> lineList(Path path) throws IOException {
            try (Stream<String> lines = this.lines(path);){
                List<String> list = lines.collect(Collectors.toList());
                return list;
            }
        }
    }
}

