/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.models;

import io.greptime.common.util.Ensures;
import io.greptime.models.DataType;
import io.greptime.models.SemanticType;
import io.greptime.v1.Common;
import java.util.ArrayList;
import java.util.List;

public class TableSchema {
    private String tableName;
    private List<String> columnNames;
    private List<Common.SemanticType> semanticTypes;
    private List<Common.ColumnDataType> dataTypes;
    private List<Common.ColumnDataTypeExtension> dataTypeExtensions;

    private TableSchema() {
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public List<Common.SemanticType> getSemanticTypes() {
        return this.semanticTypes;
    }

    public List<Common.ColumnDataType> getDataTypes() {
        return this.dataTypes;
    }

    public List<Common.ColumnDataTypeExtension> getDataTypeExtensions() {
        return this.dataTypeExtensions;
    }

    public static Builder newBuilder(String tableName) {
        return new Builder(tableName);
    }

    public static class Builder {
        private final String tableName;
        private final List<String> columnNames = new ArrayList<String>();
        private final List<Common.SemanticType> semanticTypes = new ArrayList<Common.SemanticType>();
        private final List<Common.ColumnDataType> dataTypes = new ArrayList<Common.ColumnDataType>();
        private final List<Common.ColumnDataTypeExtension> dataTypeExtensions = new ArrayList<Common.ColumnDataTypeExtension>();

        public Builder(String tableName) {
            this.tableName = tableName;
        }

        public Builder addTag(String name, DataType dataType) {
            return this.addColumn(name, SemanticType.Tag, dataType);
        }

        public Builder addTimestamp(String name, DataType dataType) {
            Ensures.ensure((boolean)dataType.isTimestamp(), (String)"Invalid timestamp data type: %s, only support `DataType.TimestampXXX`", (Object[])new Object[]{dataType});
            return this.addColumn(name, SemanticType.Timestamp, dataType);
        }

        public Builder addField(String name, DataType dataType) {
            return this.addColumn(name, SemanticType.Field, dataType);
        }

        public Builder addColumn(String name, SemanticType semanticType, DataType dataType) {
            return this.addColumn(name, semanticType, dataType, null);
        }

        public Builder addColumn(String name, SemanticType semanticType, DataType dataType, DataType.DecimalTypeExtension decimalTypeExtension) {
            Ensures.ensureNonNull((Object)name, (String)"Null column name");
            Ensures.ensureNonNull((Object)((Object)semanticType), (String)"Null semantic type");
            Ensures.ensureNonNull((Object)((Object)dataType), (String)"Null data type");
            if (semanticType == SemanticType.Timestamp) {
                Ensures.ensure((boolean)dataType.isTimestamp(), (String)"Invalid timestamp data type: %s, only support `DataType.TimestampXXX`", (Object[])new Object[]{dataType});
            }
            name = name.trim();
            this.columnNames.add(name);
            this.semanticTypes.add(semanticType.toProtoValue());
            this.dataTypes.add(dataType.toProtoValue());
            if (decimalTypeExtension == null) {
                this.dataTypeExtensions.add(Common.ColumnDataTypeExtension.getDefaultInstance());
            } else {
                Ensures.ensure((dataType == DataType.Decimal128 ? 1 : 0) != 0, (Object)"Only decimal type can have decimal type extension");
                Common.ColumnDataTypeExtension ext = Common.ColumnDataTypeExtension.newBuilder().setDecimalType(decimalTypeExtension.into()).build();
                this.dataTypeExtensions.add(ext);
            }
            return this;
        }

        public TableSchema build() {
            Ensures.ensureNonNull((Object)this.tableName, (String)"Null table name");
            Ensures.ensureNonNull(this.columnNames, (String)"Null column names");
            Ensures.ensureNonNull(this.semanticTypes, (String)"Null semantic types");
            Ensures.ensureNonNull(this.dataTypes, (String)"Null data types");
            int columnCount = this.columnNames.size();
            Ensures.ensure((columnCount > 0 ? 1 : 0) != 0, (Object)"Empty column names");
            Ensures.ensure((columnCount == this.semanticTypes.size() ? 1 : 0) != 0, (Object)"Column names size not equal to semantic types size");
            Ensures.ensure((columnCount == this.dataTypes.size() ? 1 : 0) != 0, (Object)"Column names size not equal to data types size");
            Ensures.ensure((columnCount == this.dataTypeExtensions.size() ? 1 : 0) != 0, (Object)"Column names size not equal to data type extensions size");
            TableSchema tableSchema = new TableSchema();
            tableSchema.tableName = this.tableName;
            tableSchema.columnNames = this.columnNames;
            tableSchema.semanticTypes = this.semanticTypes;
            tableSchema.dataTypes = this.dataTypes;
            tableSchema.dataTypeExtensions = this.dataTypeExtensions;
            return tableSchema;
        }
    }
}

