/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import java.util.Objects;
import org.apache.iceberg.types.JavaHashes;
import org.apache.iceberg.types.Type;

@FunctionalInterface
public interface JavaHash<T> {
    public int hash(T var1);

    public static <T> JavaHash<T> forType(Type type) {
        switch (type.typeId()) {
            case STRING: {
                return JavaHashes.strings();
            }
            case STRUCT: {
                return JavaHashes.struct(type.asStructType());
            }
            case LIST: {
                return JavaHashes.list(type.asListType());
            }
        }
        return Objects::hashCode;
    }
}

