/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.service;

import java.util.Collections;
import java.util.Optional;
import org.apache.gravitino.Entity;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.authorization.AuthorizationUtils;
import org.apache.gravitino.storage.relational.mapper.OwnerMetaMapper;
import org.apache.gravitino.storage.relational.po.GroupPO;
import org.apache.gravitino.storage.relational.po.OwnerRelPO;
import org.apache.gravitino.storage.relational.po.UserPO;
import org.apache.gravitino.storage.relational.service.GroupMetaService;
import org.apache.gravitino.storage.relational.service.MetadataObjectService;
import org.apache.gravitino.storage.relational.service.MetalakeMetaService;
import org.apache.gravitino.storage.relational.service.UserMetaService;
import org.apache.gravitino.storage.relational.utils.POConverters;
import org.apache.gravitino.storage.relational.utils.SessionUtils;
import org.apache.gravitino.utils.NameIdentifierUtil;

public class OwnerMetaService {
    private static final OwnerMetaService INSTANCE = new OwnerMetaService();

    private OwnerMetaService() {
    }

    public static OwnerMetaService getInstance() {
        return INSTANCE;
    }

    public Optional<Entity> getOwner(NameIdentifier identifier, Entity.EntityType type) {
        long metalakeId = MetalakeMetaService.getInstance().getMetalakeIdByName(NameIdentifierUtil.getMetalake(identifier));
        Long entityId = OwnerMetaService.getEntityId(metalakeId, identifier, type);
        UserPO userPO = SessionUtils.getWithoutCommit(OwnerMetaMapper.class, mapper -> mapper.selectUserOwnerMetaByMetadataObjectIdAndType(entityId, type.name()));
        if (userPO != null) {
            return Optional.of(POConverters.fromUserPO(userPO, Collections.emptyList(), AuthorizationUtils.ofUserNamespace(NameIdentifierUtil.getMetalake(identifier))));
        }
        GroupPO groupPO = SessionUtils.getWithoutCommit(OwnerMetaMapper.class, mapper -> mapper.selectGroupOwnerMetaByMetadataObjectIdAndType(entityId, type.name()));
        if (groupPO != null) {
            return Optional.of(POConverters.fromGroupPO(groupPO, Collections.emptyList(), AuthorizationUtils.ofGroupNamespace(NameIdentifierUtil.getMetalake(identifier))));
        }
        return Optional.empty();
    }

    public void setOwner(NameIdentifier entity, Entity.EntityType entityType, NameIdentifier owner, Entity.EntityType ownerType) {
        long metalakeId = MetalakeMetaService.getInstance().getMetalakeIdByName(NameIdentifierUtil.getMetalake(entity));
        Long entityId = OwnerMetaService.getEntityId(metalakeId, entity, entityType);
        Long ownerId = OwnerMetaService.getEntityId(metalakeId, owner, ownerType);
        OwnerRelPO ownerRelPO = POConverters.initializeOwnerRelPOsWithVersion(metalakeId, ownerType.name(), ownerId, entityType.name(), entityId);
        SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(OwnerMetaMapper.class, mapper -> mapper.softDeleteOwnerRelByMetadataObjectIdAndType(entityId, NameIdentifierUtil.toMetadataObject(entity, entityType).type().name())), () -> SessionUtils.doWithoutCommit(OwnerMetaMapper.class, mapper -> mapper.insertOwnerRel(ownerRelPO)));
    }

    private static long getEntityId(long metalakeId, NameIdentifier identifier, Entity.EntityType type) {
        switch (type) {
            case USER: {
                return UserMetaService.getInstance().getUserIdByMetalakeIdAndName(metalakeId, identifier.name());
            }
            case GROUP: {
                return GroupMetaService.getInstance().getGroupIdByMetalakeIdAndName(metalakeId, identifier.name());
            }
        }
        MetadataObject object = NameIdentifierUtil.toMetadataObject(identifier, type);
        return MetadataObjectService.getMetadataObjectId(metalakeId, object.fullName(), object.type());
    }
}

