/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.meta;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.gravitino.Auditable;
import org.apache.gravitino.Entity;
import org.apache.gravitino.Field;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.meta.AuditInfo;

public class TopicEntity
implements Entity,
Auditable,
HasIdentifier {
    public static final Field ID = Field.required("id", Long.class, "The unique id of the topic entity.");
    public static final Field NAME = Field.required("name", String.class, "The name of the topic entity.");
    public static final Field COMMENT = Field.optional("comment", String.class, "The comment or description of the topic entity.");
    public static final Field AUDIT_INFO = Field.required("audit_info", AuditInfo.class, "The audit details of the topic entity.");
    public static final Field PROPERTIES = Field.optional("properties", Map.class, "The properties of the topic entity.");
    private Long id;
    private String name;
    private Namespace namespace;
    private String comment;
    private AuditInfo auditInfo;
    private Map<String, String> properties;

    public static Builder builder() {
        return new Builder();
    }

    private TopicEntity() {
    }

    @Override
    public Map<Field, Object> fields() {
        HashMap fields = Maps.newHashMap();
        fields.put(ID, this.id);
        fields.put(NAME, this.name);
        fields.put(COMMENT, this.comment);
        fields.put(AUDIT_INFO, this.auditInfo);
        fields.put(PROPERTIES, this.properties);
        return Collections.unmodifiableMap(fields);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Namespace namespace() {
        return this.namespace;
    }

    @Override
    public Long id() {
        return this.id;
    }

    public String comment() {
        return this.comment;
    }

    public AuditInfo auditInfo() {
        return this.auditInfo;
    }

    @Override
    public Entity.EntityType type() {
        return Entity.EntityType.TOPIC;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TopicEntity)) {
            return false;
        }
        TopicEntity that = (TopicEntity)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.comment, that.comment) && Objects.equals(this.auditInfo, that.auditInfo) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.comment, this.auditInfo, this.properties);
    }

    public String toString() {
        return "TopicEntity(id=" + this.id + ", name=" + this.name + ", namespace=" + this.namespace + ", comment=" + this.comment + ", auditInfo=" + this.auditInfo + ", properties=" + this.properties + ")";
    }

    public static class Builder {
        private final TopicEntity topic = new TopicEntity();

        private Builder() {
        }

        public Builder withId(Long id) {
            this.topic.id = id;
            return this;
        }

        public Builder withName(String name) {
            this.topic.name = name;
            return this;
        }

        public Builder withNamespace(Namespace namespace) {
            this.topic.namespace = namespace;
            return this;
        }

        public Builder withComment(String comment) {
            this.topic.comment = comment;
            return this;
        }

        public Builder withAuditInfo(AuditInfo auditInfo) {
            this.topic.auditInfo = auditInfo;
            return this;
        }

        public Builder withProperties(Map<String, String> properties) {
            this.topic.properties = properties;
            return this;
        }

        public TopicEntity build() {
            this.topic.validate();
            return this.topic;
        }
    }
}

