/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.meta;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.gravitino.Auditable;
import org.apache.gravitino.Entity;
import org.apache.gravitino.Field;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.utils.CollectionUtils;

public class ModelVersionEntity
implements Entity,
Auditable,
HasIdentifier {
    public static final Field MODEL_IDENT = Field.required("model_ident", NameIdentifier.class, "The name identifier of the model entity.");
    public static final Field VERSION = Field.required("version", Integer.class, "The version of the model entity.");
    public static final Field COMMENT = Field.optional("comment", String.class, "The comment or description of the model entity.");
    public static final Field ALIASES = Field.optional("aliases", List.class, "The aliases of the model entity.");
    public static final Field URL = Field.required("uri", String.class, "The URI of the model entity.");
    public static final Field PROPERTIES = Field.optional("properties", Map.class, "The properties of the model entity.");
    public static final Field AUDIT_INFO = Field.required("audit_info", AuditInfo.class, "The audit details of the model entity.");
    private NameIdentifier modelIdent;
    private Integer version;
    private String comment;
    private List<String> aliases;
    private String uri;
    private AuditInfo auditInfo;
    private Map<String, String> properties;

    private ModelVersionEntity() {
    }

    @Override
    public Map<Field, Object> fields() {
        HashMap fields = Maps.newHashMap();
        fields.put(MODEL_IDENT, this.modelIdent);
        fields.put(VERSION, this.version);
        fields.put(COMMENT, this.comment);
        fields.put(ALIASES, this.aliases);
        fields.put(URL, this.uri);
        fields.put(PROPERTIES, this.properties);
        fields.put(AUDIT_INFO, this.auditInfo);
        return Collections.unmodifiableMap(fields);
    }

    public NameIdentifier modelIdentifier() {
        return this.modelIdent;
    }

    public Integer version() {
        return this.version;
    }

    public String comment() {
        return this.comment;
    }

    public List<String> aliases() {
        return this.aliases;
    }

    public String uri() {
        return this.uri;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public AuditInfo auditInfo() {
        return this.auditInfo;
    }

    @Override
    public Entity.EntityType type() {
        return Entity.EntityType.MODEL_VERSION;
    }

    @Override
    public String name() {
        return String.valueOf(this.version);
    }

    @Override
    public Namespace namespace() {
        ArrayList levels = Lists.newArrayList((Object[])this.modelIdent.namespace().levels());
        levels.add(this.modelIdent.name());
        return Namespace.of((String[])levels.toArray(new String[0]));
    }

    @Override
    public Long id() {
        throw new UnsupportedOperationException("Model version entity does not have an ID.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModelVersionEntity)) {
            return false;
        }
        ModelVersionEntity that = (ModelVersionEntity)o;
        return Objects.equals(this.version, that.version) && Objects.equals(this.modelIdent, that.modelIdent) && Objects.equals(this.comment, that.comment) && CollectionUtils.isEqualCollection(this.aliases, that.aliases) && Objects.equals(this.uri, that.uri) && Objects.equals(this.properties, that.properties) && Objects.equals(this.auditInfo, that.auditInfo);
    }

    public int hashCode() {
        return Objects.hash(this.modelIdent, this.version, this.comment, this.aliases, this.uri, this.properties, this.auditInfo);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "ModelVersionEntity(modelIdent=" + this.modelIdent + ", version=" + this.version + ", comment=" + this.comment + ", aliases=" + this.aliases + ", uri=" + this.uri + ", auditInfo=" + this.auditInfo + ", properties=" + this.properties + ")";
    }

    public static class Builder {
        private final ModelVersionEntity model = new ModelVersionEntity();

        private Builder() {
        }

        public Builder withModelIdentifier(NameIdentifier modelIdent) {
            this.model.modelIdent = modelIdent;
            return this;
        }

        public Builder withVersion(int version) {
            this.model.version = version;
            return this;
        }

        public Builder withComment(String comment) {
            this.model.comment = comment;
            return this;
        }

        public Builder withAliases(List<String> aliases) {
            this.model.aliases = aliases;
            return this;
        }

        public Builder withUri(String uri) {
            this.model.uri = uri;
            return this;
        }

        public Builder withProperties(Map<String, String> properties) {
            this.model.properties = properties;
            return this;
        }

        public Builder withAuditInfo(AuditInfo auditInfo) {
            this.model.auditInfo = auditInfo;
            return this;
        }

        public ModelVersionEntity build() {
            this.model.validate();
            this.model.aliases = this.model.aliases == null ? Collections.emptyList() : this.model.aliases;
            return this.model;
        }
    }
}

