/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SharedCacheConfig {
    protected static final Log LOG = LogFactory.getLog(SharedCacheConfig.class);
    private boolean sharedCacheFilesEnabled = false;
    private boolean sharedCacheLibjarsEnabled = false;
    private boolean sharedCacheArchivesEnabled = false;
    private boolean sharedCacheJobjarEnabled = false;

    public void init(Configuration conf) {
        if (!"yarn".equals(conf.get("mapreduce.framework.name"))) {
            return;
        }
        if (!conf.getBoolean("yarn.sharedcache.enabled", false)) {
            return;
        }
        Collection configs = StringUtils.getTrimmedStringCollection((String)conf.get("mapreduce.job.sharedcache.mode", "disabled"));
        if (configs.contains("files")) {
            this.sharedCacheFilesEnabled = true;
        }
        if (configs.contains("libjars")) {
            this.sharedCacheLibjarsEnabled = true;
        }
        if (configs.contains("archives")) {
            this.sharedCacheArchivesEnabled = true;
        }
        if (configs.contains("jobjar")) {
            this.sharedCacheJobjarEnabled = true;
        }
        if (configs.contains("enabled")) {
            this.sharedCacheFilesEnabled = true;
            this.sharedCacheLibjarsEnabled = true;
            this.sharedCacheArchivesEnabled = true;
            this.sharedCacheJobjarEnabled = true;
        }
        if (configs.contains("disabled")) {
            this.sharedCacheFilesEnabled = false;
            this.sharedCacheLibjarsEnabled = false;
            this.sharedCacheArchivesEnabled = false;
            this.sharedCacheJobjarEnabled = false;
        }
    }

    public boolean isSharedCacheFilesEnabled() {
        return this.sharedCacheFilesEnabled;
    }

    public boolean isSharedCacheLibjarsEnabled() {
        return this.sharedCacheLibjarsEnabled;
    }

    public boolean isSharedCacheArchivesEnabled() {
        return this.sharedCacheArchivesEnabled;
    }

    public boolean isSharedCacheJobjarEnabled() {
        return this.sharedCacheJobjarEnabled;
    }

    public boolean isSharedCacheEnabled() {
        return this.sharedCacheFilesEnabled || this.sharedCacheLibjarsEnabled || this.sharedCacheArchivesEnabled || this.sharedCacheJobjarEnabled;
    }
}

