/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.responses;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.rest.responses.ConfigResponse;
import org.apache.iceberg.util.JsonUtil;

public class ConfigResponseParser {
    private static final String DEFAULTS = "defaults";
    private static final String OVERRIDES = "overrides";

    private ConfigResponseParser() {
    }

    public static String toJson(ConfigResponse response) {
        return ConfigResponseParser.toJson(response, false);
    }

    public static String toJson(ConfigResponse response, boolean pretty) {
        return JsonUtil.generate(gen -> ConfigResponseParser.toJson(response, gen), pretty);
    }

    public static void toJson(ConfigResponse response, JsonGenerator gen) throws IOException {
        Preconditions.checkArgument((null != response ? 1 : 0) != 0, (Object)"Invalid config response: null");
        gen.writeStartObject();
        JsonUtil.writeStringMap(DEFAULTS, response.defaults(), gen);
        JsonUtil.writeStringMap(OVERRIDES, response.overrides(), gen);
        gen.writeEndObject();
    }

    public static ConfigResponse fromJson(String json) {
        return JsonUtil.parse(json, ConfigResponseParser::fromJson);
    }

    public static ConfigResponse fromJson(JsonNode json) {
        Preconditions.checkArgument((null != json ? 1 : 0) != 0, (Object)"Cannot parse config response from null object");
        ConfigResponse.Builder builder = ConfigResponse.builder();
        if (json.hasNonNull(DEFAULTS)) {
            builder.withDefaults(JsonUtil.getStringMapNullableValues(DEFAULTS, json));
        }
        if (json.hasNonNull(OVERRIDES)) {
            builder.withOverrides(JsonUtil.getStringMapNullableValues(OVERRIDES, json));
        }
        return builder.build();
    }
}

