/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.auth;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.iceberg.rest.ResourcePaths;
import org.apache.iceberg.rest.auth.ImmutableAuthConfig;
import org.apache.iceberg.rest.auth.OAuth2Util;
import org.immutables.value.Value;

@Value.Style(redactedMask="****")
@Value.Immutable
public interface AuthConfig {
    @Nullable
    @Value.Redacted
    public String token();

    @Nullable
    public String tokenType();

    @Nullable
    @Value.Redacted
    public String credential();

    @Value.Default
    default public String scope() {
        return "catalog";
    }

    @Nullable
    @Value.Lazy
    default public Long expiresAtMillis() {
        return OAuth2Util.expiresAtMillis(this.token());
    }

    @Value.Default
    default public boolean keepRefreshed() {
        return true;
    }

    @Nullable
    @Value.Default
    default public String oauth2ServerUri() {
        return ResourcePaths.tokens();
    }

    public Map<String, String> optionalOAuthParams();

    public static ImmutableAuthConfig.Builder builder() {
        return ImmutableAuthConfig.builder();
    }
}

