/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import org.apache.iceberg.avro.AvroWithPartnerByStructureVisitor;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Pair;

public class AvroWithTypeByStructureVisitor<T>
extends AvroWithPartnerByStructureVisitor<Type, T> {
    @Override
    protected boolean isMapType(Type type) {
        return type.isMapType();
    }

    @Override
    protected boolean isStringType(Type type) {
        return type.isPrimitiveType() && type.asPrimitiveType().typeId() == Type.TypeID.STRING;
    }

    @Override
    protected Type arrayElementType(Type arrayType) {
        return arrayType.asListType().elementType();
    }

    @Override
    protected Type mapKeyType(Type mapType) {
        return mapType.asMapType().keyType();
    }

    @Override
    protected Type mapValueType(Type mapType) {
        return mapType.asMapType().valueType();
    }

    @Override
    protected Pair<String, Type> fieldNameAndType(Type structType, int pos) {
        Types.NestedField field = (Types.NestedField)structType.asStructType().fields().get(pos);
        return Pair.of(field.name(), field.type());
    }

    @Override
    protected Type nullType() {
        return null;
    }
}

