/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.service;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.storage.relational.po.CatalogPO;
import org.apache.gravitino.storage.relational.po.ColumnPO;
import org.apache.gravitino.storage.relational.po.FilesetPO;
import org.apache.gravitino.storage.relational.po.MetalakePO;
import org.apache.gravitino.storage.relational.po.ModelPO;
import org.apache.gravitino.storage.relational.po.SchemaPO;
import org.apache.gravitino.storage.relational.po.TablePO;
import org.apache.gravitino.storage.relational.po.TopicPO;
import org.apache.gravitino.storage.relational.service.CatalogMetaService;
import org.apache.gravitino.storage.relational.service.FilesetMetaService;
import org.apache.gravitino.storage.relational.service.MetalakeMetaService;
import org.apache.gravitino.storage.relational.service.ModelMetaService;
import org.apache.gravitino.storage.relational.service.RoleMetaService;
import org.apache.gravitino.storage.relational.service.SchemaMetaService;
import org.apache.gravitino.storage.relational.service.TableColumnMetaService;
import org.apache.gravitino.storage.relational.service.TableMetaService;
import org.apache.gravitino.storage.relational.service.TopicMetaService;

public class MetadataObjectService {
    private static final String DOT = ".";
    private static final Joiner DOT_JOINER = Joiner.on((String)".");
    private static final Splitter DOT_SPLITTER = Splitter.on((String)".");

    private MetadataObjectService() {
    }

    public static long getMetadataObjectId(long metalakeId, String fullName, MetadataObject.Type type) {
        if (type == MetadataObject.Type.METALAKE) {
            return MetalakeMetaService.getInstance().getMetalakeIdByName(fullName);
        }
        if (type == MetadataObject.Type.ROLE) {
            return RoleMetaService.getInstance().getRoleIdByMetalakeIdAndName(metalakeId, fullName);
        }
        List names = DOT_SPLITTER.splitToList((CharSequence)fullName);
        long catalogId = CatalogMetaService.getInstance().getCatalogIdByMetalakeIdAndName(metalakeId, (String)names.get(0));
        if (type == MetadataObject.Type.CATALOG) {
            return catalogId;
        }
        long schemaId = SchemaMetaService.getInstance().getSchemaIdByCatalogIdAndName(catalogId, (String)names.get(1));
        if (type == MetadataObject.Type.SCHEMA) {
            return schemaId;
        }
        if (type == MetadataObject.Type.FILESET) {
            return FilesetMetaService.getInstance().getFilesetIdBySchemaIdAndName(schemaId, (String)names.get(2));
        }
        if (type == MetadataObject.Type.TOPIC) {
            return TopicMetaService.getInstance().getTopicIdBySchemaIdAndName(schemaId, (String)names.get(2));
        }
        if (type == MetadataObject.Type.MODEL) {
            return ModelMetaService.getInstance().getModelIdBySchemaIdAndModelName(schemaId, (String)names.get(2));
        }
        long tableId = TableMetaService.getInstance().getTableIdBySchemaIdAndName(schemaId, (String)names.get(2));
        if (type == MetadataObject.Type.TABLE) {
            return tableId;
        }
        if (type == MetadataObject.Type.COLUMN) {
            return TableColumnMetaService.getInstance().getColumnIdByTableIdAndName(tableId, (String)names.get(3));
        }
        throw new IllegalArgumentException(String.format("Doesn't support the type %s", type));
    }

    @Nullable
    public static String getMetadataObjectFullName(String type, long metadataObjectId) {
        MetadataObject.Type metadataType = MetadataObject.Type.valueOf((String)type);
        String fullName = null;
        long objectId = metadataObjectId;
        do {
            switch (metadataType) {
                case METALAKE: {
                    MetalakePO metalakePO = MetalakeMetaService.getInstance().getMetalakePOById(objectId);
                    if (metalakePO != null) {
                        fullName = metalakePO.getMetalakeName();
                        metadataType = null;
                        break;
                    }
                    return null;
                }
                case CATALOG: {
                    CatalogPO catalogPO = CatalogMetaService.getInstance().getCatalogPOById(objectId);
                    if (catalogPO != null) {
                        fullName = fullName != null ? DOT_JOINER.join((Object)catalogPO.getCatalogName(), (Object)fullName, new Object[0]) : catalogPO.getCatalogName();
                        metadataType = null;
                        break;
                    }
                    return null;
                }
                case SCHEMA: {
                    SchemaPO schemaPO = SchemaMetaService.getInstance().getSchemaPOById(objectId);
                    if (schemaPO != null) {
                        fullName = fullName != null ? DOT_JOINER.join((Object)schemaPO.getSchemaName(), (Object)fullName, new Object[0]) : schemaPO.getSchemaName();
                        objectId = schemaPO.getCatalogId();
                        metadataType = MetadataObject.Type.CATALOG;
                        break;
                    }
                    return null;
                }
                case TABLE: {
                    TablePO tablePO = TableMetaService.getInstance().getTablePOById(objectId);
                    if (tablePO != null) {
                        fullName = fullName != null ? DOT_JOINER.join((Object)tablePO.getTableName(), (Object)fullName, new Object[0]) : tablePO.getTableName();
                        objectId = tablePO.getSchemaId();
                        metadataType = MetadataObject.Type.SCHEMA;
                        break;
                    }
                    return null;
                }
                case TOPIC: {
                    TopicPO topicPO = TopicMetaService.getInstance().getTopicPOById(objectId);
                    if (topicPO != null) {
                        fullName = fullName != null ? DOT_JOINER.join((Object)topicPO.getTopicName(), (Object)fullName, new Object[0]) : topicPO.getTopicName();
                        objectId = topicPO.getSchemaId();
                        metadataType = MetadataObject.Type.SCHEMA;
                        break;
                    }
                    return null;
                }
                case FILESET: {
                    FilesetPO filesetPO = FilesetMetaService.getInstance().getFilesetPOById(objectId);
                    if (filesetPO != null) {
                        fullName = fullName != null ? DOT_JOINER.join((Object)filesetPO.getFilesetName(), (Object)fullName, new Object[0]) : filesetPO.getFilesetName();
                        objectId = filesetPO.getSchemaId();
                        metadataType = MetadataObject.Type.SCHEMA;
                        break;
                    }
                    return null;
                }
                case MODEL: {
                    ModelPO modelPO = ModelMetaService.getInstance().getModelPOById(objectId);
                    if (modelPO != null) {
                        fullName = fullName != null ? DOT_JOINER.join((Object)modelPO.getModelName(), (Object)fullName, new Object[0]) : modelPO.getModelName();
                        objectId = modelPO.getSchemaId();
                        metadataType = MetadataObject.Type.SCHEMA;
                        break;
                    }
                    return null;
                }
                case COLUMN: {
                    ColumnPO columnPO = TableColumnMetaService.getInstance().getColumnPOById(objectId);
                    if (columnPO != null) {
                        fullName = fullName != null ? DOT_JOINER.join((Object)columnPO.getColumnName(), (Object)fullName, new Object[0]) : columnPO.getColumnName();
                        objectId = columnPO.getTableId();
                        metadataType = MetadataObject.Type.TABLE;
                        break;
                    }
                    return null;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Doesn't support the type %s", metadataType));
                }
            }
        } while (metadataType != null);
        return fullName;
    }
}

