/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog;

import java.util.Map;
import java.util.function.Supplier;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.StringIdentifier;
import org.apache.gravitino.catalog.CatalogManager;
import org.apache.gravitino.catalog.EntityCombinedModel;
import org.apache.gravitino.catalog.EntityCombinedModelVersion;
import org.apache.gravitino.catalog.ModelDispatcher;
import org.apache.gravitino.catalog.OperationDispatcher;
import org.apache.gravitino.catalog.PropertiesMetadataHelpers;
import org.apache.gravitino.connector.HasPropertyMetadata;
import org.apache.gravitino.exceptions.ModelAlreadyExistsException;
import org.apache.gravitino.exceptions.ModelVersionAliasesAlreadyExistException;
import org.apache.gravitino.exceptions.NoSuchModelException;
import org.apache.gravitino.exceptions.NoSuchModelVersionException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.lock.LockType;
import org.apache.gravitino.lock.TreeLockUtils;
import org.apache.gravitino.model.Model;
import org.apache.gravitino.model.ModelVersion;
import org.apache.gravitino.storage.IdGenerator;
import org.apache.gravitino.utils.NameIdentifierUtil;

public class ModelOperationDispatcher
extends OperationDispatcher
implements ModelDispatcher {
    public ModelOperationDispatcher(CatalogManager catalogManager, EntityStore store, IdGenerator idGenerator) {
        super(catalogManager, store, idGenerator);
    }

    public NameIdentifier[] listModels(Namespace namespace) throws NoSuchSchemaException {
        return TreeLockUtils.doWithTreeLock(NameIdentifier.of((String[])namespace.levels()), LockType.READ, () -> this.doWithCatalog(NameIdentifierUtil.getCatalogIdentifier(NameIdentifier.of((String[])namespace.levels())), c -> c.doWithModelOps(m -> m.listModels(namespace)), NoSuchSchemaException.class));
    }

    public Model getModel(NameIdentifier ident) throws NoSuchModelException {
        NameIdentifier catalogIdent = NameIdentifierUtil.getCatalogIdentifier(ident);
        Model model = TreeLockUtils.doWithTreeLock(ident, LockType.READ, () -> this.doWithCatalog(catalogIdent, c -> c.doWithModelOps(m -> m.getModel(ident)), NoSuchModelException.class));
        return EntityCombinedModel.of(model).withHiddenProperties(this.getHiddenPropertyNames(catalogIdent, HasPropertyMetadata::modelPropertiesMetadata, model.properties()));
    }

    public Model registerModel(NameIdentifier ident, String comment, Map<String, String> properties) throws NoSuchModelException, ModelAlreadyExistsException {
        NameIdentifier catalogIdent = NameIdentifierUtil.getCatalogIdentifier(ident);
        Map<String, String> updatedProperties = this.checkAndUpdateProperties(catalogIdent, properties);
        Model registeredModel = TreeLockUtils.doWithTreeLock(NameIdentifier.of((String[])ident.namespace().levels()), LockType.WRITE, () -> this.doWithCatalog(catalogIdent, c -> c.doWithModelOps(m -> m.registerModel(ident, comment, updatedProperties)), NoSuchSchemaException.class, ModelAlreadyExistsException.class));
        return EntityCombinedModel.of(registeredModel).withHiddenProperties(this.getHiddenPropertyNames(catalogIdent, HasPropertyMetadata::modelPropertiesMetadata, registeredModel.properties()));
    }

    public boolean deleteModel(NameIdentifier ident) {
        return TreeLockUtils.doWithTreeLock(NameIdentifier.of((String[])ident.namespace().levels()), LockType.WRITE, () -> this.doWithCatalog(NameIdentifierUtil.getCatalogIdentifier(ident), c -> c.doWithModelOps(m -> m.deleteModel(ident)), RuntimeException.class));
    }

    public int[] listModelVersions(NameIdentifier ident) throws NoSuchModelException {
        return TreeLockUtils.doWithTreeLock(ident, LockType.READ, () -> this.doWithCatalog(NameIdentifierUtil.getCatalogIdentifier(ident), c -> c.doWithModelOps(m -> m.listModelVersions(ident)), NoSuchModelException.class));
    }

    public ModelVersion getModelVersion(NameIdentifier ident, int version) throws NoSuchModelVersionException {
        return this.internalGetModelVersion(ident, () -> TreeLockUtils.doWithTreeLock(ident, LockType.READ, () -> this.doWithCatalog(NameIdentifierUtil.getCatalogIdentifier(ident), c -> c.doWithModelOps(m -> m.getModelVersion(ident, version)), NoSuchModelVersionException.class)));
    }

    public ModelVersion getModelVersion(NameIdentifier ident, String alias) throws NoSuchModelVersionException {
        return this.internalGetModelVersion(ident, () -> TreeLockUtils.doWithTreeLock(ident, LockType.READ, () -> this.doWithCatalog(NameIdentifierUtil.getCatalogIdentifier(ident), c -> c.doWithModelOps(m -> m.getModelVersion(ident, alias)), NoSuchModelVersionException.class)));
    }

    public void linkModelVersion(NameIdentifier ident, String uri, String[] aliases, String comment, Map<String, String> properties) throws NoSuchModelException, ModelVersionAliasesAlreadyExistException {
        NameIdentifier catalogIdent = NameIdentifierUtil.getCatalogIdentifier(ident);
        Map<String, String> updatedProperties = this.checkAndUpdateProperties(catalogIdent, properties);
        TreeLockUtils.doWithTreeLock(ident, LockType.WRITE, () -> this.doWithCatalog(catalogIdent, c -> c.doWithModelOps(m -> {
            m.linkModelVersion(ident, uri, aliases, comment, updatedProperties);
            return null;
        }), NoSuchModelException.class, ModelVersionAliasesAlreadyExistException.class));
    }

    public boolean deleteModelVersion(NameIdentifier ident, int version) {
        return TreeLockUtils.doWithTreeLock(ident, LockType.WRITE, () -> this.doWithCatalog(NameIdentifierUtil.getCatalogIdentifier(ident), c -> c.doWithModelOps(m -> m.deleteModelVersion(ident, version)), RuntimeException.class));
    }

    public boolean deleteModelVersion(NameIdentifier ident, String alias) {
        return TreeLockUtils.doWithTreeLock(ident, LockType.WRITE, () -> this.doWithCatalog(NameIdentifierUtil.getCatalogIdentifier(ident), c -> c.doWithModelOps(m -> m.deleteModelVersion(ident, alias)), RuntimeException.class));
    }

    private ModelVersion internalGetModelVersion(NameIdentifier ident, Supplier<ModelVersion> supplier) {
        NameIdentifier catalogIdent = NameIdentifierUtil.getCatalogIdentifier(ident);
        ModelVersion modelVersion = supplier.get();
        return EntityCombinedModelVersion.of(modelVersion).withHiddenProperties(this.getHiddenPropertyNames(catalogIdent, HasPropertyMetadata::modelPropertiesMetadata, modelVersion.properties()));
    }

    private Map<String, String> checkAndUpdateProperties(NameIdentifier catalogIdent, Map<String, String> properties) {
        TreeLockUtils.doWithTreeLock(catalogIdent, LockType.READ, () -> this.doWithCatalog(catalogIdent, c -> c.doWithPropertiesMeta(p -> {
            PropertiesMetadataHelpers.validatePropertyForCreate(p.modelPropertiesMetadata(), properties);
            return null;
        }), IllegalArgumentException.class));
        long uid = this.idGenerator.nextId();
        StringIdentifier stringId = StringIdentifier.fromId(uid);
        return StringIdentifier.newPropertiesWithId(stringId, properties);
    }
}

