/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.audit;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.gravitino.listener.api.event.AlterCatalogEvent;
import org.apache.gravitino.listener.api.event.AlterCatalogFailureEvent;
import org.apache.gravitino.listener.api.event.AlterFilesetEvent;
import org.apache.gravitino.listener.api.event.AlterFilesetFailureEvent;
import org.apache.gravitino.listener.api.event.AlterMetalakeEvent;
import org.apache.gravitino.listener.api.event.AlterMetalakeFailureEvent;
import org.apache.gravitino.listener.api.event.AlterSchemaEvent;
import org.apache.gravitino.listener.api.event.AlterSchemaFailureEvent;
import org.apache.gravitino.listener.api.event.AlterTableEvent;
import org.apache.gravitino.listener.api.event.AlterTableFailureEvent;
import org.apache.gravitino.listener.api.event.AlterTopicEvent;
import org.apache.gravitino.listener.api.event.AlterTopicFailureEvent;
import org.apache.gravitino.listener.api.event.CreateCatalogEvent;
import org.apache.gravitino.listener.api.event.CreateCatalogFailureEvent;
import org.apache.gravitino.listener.api.event.CreateFilesetEvent;
import org.apache.gravitino.listener.api.event.CreateFilesetFailureEvent;
import org.apache.gravitino.listener.api.event.CreateMetalakeEvent;
import org.apache.gravitino.listener.api.event.CreateMetalakeFailureEvent;
import org.apache.gravitino.listener.api.event.CreateSchemaEvent;
import org.apache.gravitino.listener.api.event.CreateSchemaFailureEvent;
import org.apache.gravitino.listener.api.event.CreateTableEvent;
import org.apache.gravitino.listener.api.event.CreateTableFailureEvent;
import org.apache.gravitino.listener.api.event.CreateTopicEvent;
import org.apache.gravitino.listener.api.event.CreateTopicFailureEvent;
import org.apache.gravitino.listener.api.event.DropCatalogEvent;
import org.apache.gravitino.listener.api.event.DropCatalogFailureEvent;
import org.apache.gravitino.listener.api.event.DropFilesetEvent;
import org.apache.gravitino.listener.api.event.DropFilesetFailureEvent;
import org.apache.gravitino.listener.api.event.DropMetalakeEvent;
import org.apache.gravitino.listener.api.event.DropMetalakeFailureEvent;
import org.apache.gravitino.listener.api.event.DropSchemaEvent;
import org.apache.gravitino.listener.api.event.DropSchemaFailureEvent;
import org.apache.gravitino.listener.api.event.DropTableEvent;
import org.apache.gravitino.listener.api.event.DropTableFailureEvent;
import org.apache.gravitino.listener.api.event.DropTopicEvent;
import org.apache.gravitino.listener.api.event.DropTopicFailureEvent;
import org.apache.gravitino.listener.api.event.Event;
import org.apache.gravitino.listener.api.event.EventSource;
import org.apache.gravitino.listener.api.event.GetFileLocationEvent;
import org.apache.gravitino.listener.api.event.GetFileLocationFailureEvent;
import org.apache.gravitino.listener.api.event.GetPartitionEvent;
import org.apache.gravitino.listener.api.event.GetPartitionFailureEvent;
import org.apache.gravitino.listener.api.event.ListCatalogEvent;
import org.apache.gravitino.listener.api.event.ListCatalogFailureEvent;
import org.apache.gravitino.listener.api.event.ListFilesetEvent;
import org.apache.gravitino.listener.api.event.ListFilesetFailureEvent;
import org.apache.gravitino.listener.api.event.ListMetalakeEvent;
import org.apache.gravitino.listener.api.event.ListMetalakeFailureEvent;
import org.apache.gravitino.listener.api.event.ListPartitionEvent;
import org.apache.gravitino.listener.api.event.ListPartitionFailureEvent;
import org.apache.gravitino.listener.api.event.ListSchemaEvent;
import org.apache.gravitino.listener.api.event.ListSchemaFailureEvent;
import org.apache.gravitino.listener.api.event.ListTableEvent;
import org.apache.gravitino.listener.api.event.ListTableFailureEvent;
import org.apache.gravitino.listener.api.event.ListTopicEvent;
import org.apache.gravitino.listener.api.event.ListTopicFailureEvent;
import org.apache.gravitino.listener.api.event.LoadCatalogEvent;
import org.apache.gravitino.listener.api.event.LoadCatalogFailureEvent;
import org.apache.gravitino.listener.api.event.LoadFilesetEvent;
import org.apache.gravitino.listener.api.event.LoadFilesetFailureEvent;
import org.apache.gravitino.listener.api.event.LoadMetalakeEvent;
import org.apache.gravitino.listener.api.event.LoadMetalakeFailureEvent;
import org.apache.gravitino.listener.api.event.LoadSchemaEvent;
import org.apache.gravitino.listener.api.event.LoadSchemaFailureEvent;
import org.apache.gravitino.listener.api.event.LoadTableEvent;
import org.apache.gravitino.listener.api.event.LoadTableFailureEvent;
import org.apache.gravitino.listener.api.event.LoadTopicEvent;
import org.apache.gravitino.listener.api.event.LoadTopicFailureEvent;
import org.apache.gravitino.listener.api.event.OperationStatus;
import org.apache.gravitino.listener.api.event.OperationType;
import org.apache.gravitino.listener.api.event.PartitionExistsEvent;
import org.apache.gravitino.listener.api.event.PartitionExistsFailureEvent;
import org.apache.gravitino.listener.api.event.PurgePartitionEvent;
import org.apache.gravitino.listener.api.event.PurgePartitionFailureEvent;
import org.apache.gravitino.listener.api.event.PurgeTableEvent;
import org.apache.gravitino.listener.api.event.PurgeTableFailureEvent;

public interface AuditLog {
    public String user();

    @Deprecated
    public Operation operation();

    public String identifier();

    public long timestamp();

    @Deprecated
    public Status status();

    default public String remoteAddress() {
        return "unknown";
    }

    default public OperationStatus operationStatus() {
        return OperationStatus.UNKNOWN;
    }

    default public OperationType operationType() {
        return OperationType.UNKNOWN;
    }

    default public Map<String, String> customInfo() {
        return ImmutableMap.of();
    }

    default public EventSource eventSource() {
        return EventSource.GRAVITINO_SERVER;
    }

    public static enum Status {
        SUCCESS,
        FAILURE,
        UNKNOWN;

    }

    public static enum Operation {
        CREATE_METALAKE,
        ALTER_METALAKE,
        DROP_METALAKE,
        LOAD_METALAKE,
        LIST_METALAKE,
        CREATE_CATALOG,
        LOAD_CATALOG,
        ALTER_CATALOG,
        DROP_CATALOG,
        LIST_CATALOG,
        CREATE_SCHEMA,
        ALTER_SCHEMA,
        DROP_SCHEMA,
        LOAD_SCHEMA,
        LIST_SCHEMA,
        CREATE_TABLE,
        ALTER_TABLE,
        DROP_TABLE,
        LOAD_TABLE,
        PURGE_TABLE,
        LIST_TABLE,
        PARTITION_EXIST,
        PURGE_PARTITION,
        LIST_PARTITION,
        GET_PARTITION,
        CREATE_TOPIC,
        ALTER_TOPIC,
        DROP_TOPIC,
        LOAD_TOPIC,
        LIST_TOPIC,
        GET_FILE_LOCATION,
        CREATE_FILESET,
        ALTER_FILESET,
        DROP_FILESET,
        LOAD_FILESET,
        LIST_FILESET,
        UNKNOWN_OPERATION;


        public static Operation fromEvent(Event event) {
            if (event instanceof CreateMetalakeEvent || event instanceof CreateMetalakeFailureEvent) {
                return CREATE_METALAKE;
            }
            if (event instanceof AlterMetalakeEvent || event instanceof AlterMetalakeFailureEvent) {
                return ALTER_METALAKE;
            }
            if (event instanceof DropMetalakeEvent || event instanceof DropMetalakeFailureEvent) {
                return DROP_METALAKE;
            }
            if (event instanceof LoadMetalakeEvent || event instanceof LoadMetalakeFailureEvent) {
                return LOAD_METALAKE;
            }
            if (event instanceof ListMetalakeEvent || event instanceof ListMetalakeFailureEvent) {
                return LIST_METALAKE;
            }
            if (event instanceof CreateCatalogEvent || event instanceof CreateCatalogFailureEvent) {
                return CREATE_CATALOG;
            }
            if (event instanceof AlterCatalogEvent || event instanceof AlterCatalogFailureEvent) {
                return ALTER_CATALOG;
            }
            if (event instanceof DropCatalogEvent || event instanceof DropCatalogFailureEvent) {
                return DROP_CATALOG;
            }
            if (event instanceof LoadCatalogEvent || event instanceof LoadCatalogFailureEvent) {
                return LOAD_CATALOG;
            }
            if (event instanceof ListCatalogEvent || event instanceof ListCatalogFailureEvent) {
                return LIST_CATALOG;
            }
            if (event instanceof CreateSchemaEvent || event instanceof CreateSchemaFailureEvent) {
                return CREATE_SCHEMA;
            }
            if (event instanceof AlterSchemaEvent || event instanceof AlterSchemaFailureEvent) {
                return ALTER_SCHEMA;
            }
            if (event instanceof DropSchemaEvent || event instanceof DropSchemaFailureEvent) {
                return DROP_SCHEMA;
            }
            if (event instanceof LoadSchemaEvent || event instanceof LoadSchemaFailureEvent) {
                return LOAD_SCHEMA;
            }
            if (event instanceof ListSchemaEvent || event instanceof ListSchemaFailureEvent) {
                return LIST_SCHEMA;
            }
            if (event instanceof CreateTableEvent || event instanceof CreateTableFailureEvent) {
                return CREATE_TABLE;
            }
            if (event instanceof AlterTableEvent || event instanceof AlterTableFailureEvent) {
                return ALTER_TABLE;
            }
            if (event instanceof DropTableEvent || event instanceof DropTableFailureEvent) {
                return DROP_TABLE;
            }
            if (event instanceof LoadTableEvent || event instanceof LoadTableFailureEvent) {
                return LOAD_TABLE;
            }
            if (event instanceof PurgeTableEvent || event instanceof PurgeTableFailureEvent) {
                return PURGE_TABLE;
            }
            if (event instanceof ListTableEvent || event instanceof ListTableFailureEvent) {
                return LIST_TABLE;
            }
            if (event instanceof PartitionExistsEvent || event instanceof PartitionExistsFailureEvent) {
                return PARTITION_EXIST;
            }
            if (event instanceof PurgePartitionEvent || event instanceof PurgePartitionFailureEvent) {
                return PURGE_PARTITION;
            }
            if (event instanceof ListPartitionEvent || event instanceof ListPartitionFailureEvent) {
                return LIST_PARTITION;
            }
            if (event instanceof GetPartitionEvent || event instanceof GetPartitionFailureEvent) {
                return GET_PARTITION;
            }
            if (event instanceof CreateTopicEvent || event instanceof CreateTopicFailureEvent) {
                return CREATE_TOPIC;
            }
            if (event instanceof AlterTopicEvent || event instanceof AlterTopicFailureEvent) {
                return ALTER_TOPIC;
            }
            if (event instanceof DropTopicEvent || event instanceof DropTopicFailureEvent) {
                return DROP_TOPIC;
            }
            if (event instanceof LoadTopicEvent || event instanceof LoadTopicFailureEvent) {
                return LOAD_TOPIC;
            }
            if (event instanceof ListTopicEvent || event instanceof ListTopicFailureEvent) {
                return LIST_TOPIC;
            }
            if (event instanceof CreateFilesetEvent || event instanceof CreateFilesetFailureEvent) {
                return CREATE_FILESET;
            }
            if (event instanceof AlterFilesetEvent || event instanceof AlterFilesetFailureEvent) {
                return ALTER_FILESET;
            }
            if (event instanceof DropFilesetEvent || event instanceof DropFilesetFailureEvent) {
                return DROP_FILESET;
            }
            if (event instanceof GetFileLocationEvent || event instanceof GetFileLocationFailureEvent) {
                return GET_FILE_LOCATION;
            }
            if (event instanceof LoadFilesetEvent || event instanceof LoadFilesetFailureEvent) {
                return LOAD_FILESET;
            }
            if (event instanceof ListFilesetEvent || event instanceof ListFilesetFailureEvent) {
                return LIST_FILESET;
            }
            return UNKNOWN_OPERATION;
        }
    }
}

