/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.util.StructProjection;

class StaticDataTask
implements DataTask {
    private final DataFile metadataFile;
    private final StructLike[] rows;
    private final Schema tableSchema;
    private final Schema projectedSchema;

    static <T> DataTask of(InputFile metadata, Schema tableSchema, Schema projectedSchema, Iterable<T> values, Function<T, Row> transform) {
        return new StaticDataTask(metadata, tableSchema, projectedSchema, Lists.newArrayList((Iterable)Iterables.transform(values, transform::apply)).toArray(new Row[0]));
    }

    private StaticDataTask(InputFile metadata, Schema tableSchema, Schema projectedSchema, StructLike[] rows) {
        this.tableSchema = tableSchema;
        this.projectedSchema = projectedSchema;
        this.metadataFile = DataFiles.builder(PartitionSpec.unpartitioned()).withInputFile(metadata).withRecordCount(rows.length).withFormat(FileFormat.METADATA).build();
        this.rows = rows;
    }

    public List<DeleteFile> deletes() {
        return ImmutableList.of();
    }

    public CloseableIterable<StructLike> rows() {
        StructProjection projection = StructProjection.create((Schema)this.tableSchema, (Schema)this.projectedSchema);
        Iterable projectedRows = Iterables.transform(Arrays.asList(this.rows), arg_0 -> ((StructProjection)projection).wrap(arg_0));
        return CloseableIterable.withNoopClose((Iterable)projectedRows);
    }

    public DataFile file() {
        return this.metadataFile;
    }

    public PartitionSpec spec() {
        return PartitionSpec.unpartitioned();
    }

    public long start() {
        return 0L;
    }

    public long length() {
        return this.metadataFile.fileSizeInBytes();
    }

    public Expression residual() {
        return Expressions.alwaysTrue();
    }

    public Iterable<FileScanTask> split(long splitSize) {
        return ImmutableList.of((Object)this);
    }

    static class Row
    implements StructLike,
    Serializable {
        private final Object[] values;

        public static Row of(Object ... values) {
            return new Row(values);
        }

        private Row(Object ... values) {
            this.values = values;
        }

        public int size() {
            return this.values.length;
        }

        public <T> T get(int pos, Class<T> javaClass) {
            return javaClass.cast(this.values[pos]);
        }

        public <T> void set(int pos, T value) {
            throw new UnsupportedOperationException("Setting values is not supported");
        }
    }
}

