/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.client.BaseSchemaCatalog;
import org.apache.gravitino.client.DTOConverters;
import org.apache.gravitino.client.ErrorHandlers;
import org.apache.gravitino.client.RESTClient;
import org.apache.gravitino.client.RelationalTable;
import org.apache.gravitino.dto.AuditDTO;
import org.apache.gravitino.dto.CatalogDTO;
import org.apache.gravitino.dto.requests.TableCreateRequest;
import org.apache.gravitino.dto.requests.TableUpdatesRequest;
import org.apache.gravitino.dto.responses.DropResponse;
import org.apache.gravitino.dto.responses.EntityListResponse;
import org.apache.gravitino.dto.responses.TableResponse;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.exceptions.TableAlreadyExistsException;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.Table;
import org.apache.gravitino.rel.TableCatalog;
import org.apache.gravitino.rel.TableChange;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.indexes.Index;
import org.apache.gravitino.rest.RESTRequest;
import org.apache.gravitino.rest.RESTUtils;

class RelationalCatalog
extends BaseSchemaCatalog
implements TableCatalog {
    RelationalCatalog(Namespace namespace, String name, Catalog.Type type, String provider, String comment, Map<String, String> properties, AuditDTO auditDTO, RESTClient restClient) {
        super(namespace, name, type, provider, comment, properties, auditDTO, restClient);
    }

    public TableCatalog asTableCatalog() {
        return this;
    }

    public NameIdentifier[] listTables(Namespace namespace) throws NoSuchSchemaException {
        RelationalCatalog.checkTableNamespace(namespace);
        Namespace fullNamespace = this.getTableFullNamespace(namespace);
        EntityListResponse resp = this.restClient.get(RelationalCatalog.formatTableRequestPath(fullNamespace), EntityListResponse.class, Collections.emptyMap(), ErrorHandlers.tableErrorHandler());
        resp.validate();
        return (NameIdentifier[])Arrays.stream(resp.identifiers()).map(ident -> NameIdentifier.of((String[])new String[]{ident.namespace().level(2), ident.name()})).toArray(NameIdentifier[]::new);
    }

    public Table loadTable(NameIdentifier ident) throws NoSuchTableException {
        RelationalCatalog.checkTableNameIdentifier(ident);
        Namespace fullNamespace = this.getTableFullNamespace(ident.namespace());
        TableResponse resp = this.restClient.get(RelationalCatalog.formatTableRequestPath(fullNamespace) + "/" + RESTUtils.encodeString((String)ident.name()), TableResponse.class, Collections.emptyMap(), ErrorHandlers.tableErrorHandler());
        resp.validate();
        return RelationalTable.from(fullNamespace, resp.getTable(), this.restClient);
    }

    public Table createTable(NameIdentifier ident, Column[] columns, String comment, Map<String, String> properties, Transform[] partitioning, Distribution distribution, SortOrder[] sortOrders, Index[] indexes) throws NoSuchSchemaException, TableAlreadyExistsException {
        RelationalCatalog.checkTableNameIdentifier(ident);
        TableCreateRequest req = new TableCreateRequest(ident.name(), comment, org.apache.gravitino.dto.util.DTOConverters.toDTOs((Column[])columns), properties, org.apache.gravitino.dto.util.DTOConverters.toDTOs((SortOrder[])sortOrders), org.apache.gravitino.dto.util.DTOConverters.toDTO((Distribution)distribution), org.apache.gravitino.dto.util.DTOConverters.toDTOs((Transform[])partitioning), org.apache.gravitino.dto.util.DTOConverters.toDTOs((Index[])indexes));
        req.validate();
        Namespace fullNamespace = this.getTableFullNamespace(ident.namespace());
        TableResponse resp = this.restClient.post(RelationalCatalog.formatTableRequestPath(fullNamespace), (RESTRequest)req, TableResponse.class, Collections.emptyMap(), ErrorHandlers.tableErrorHandler());
        resp.validate();
        return RelationalTable.from(fullNamespace, resp.getTable(), this.restClient);
    }

    public Table alterTable(NameIdentifier ident, TableChange ... changes) throws NoSuchTableException, IllegalArgumentException {
        RelationalCatalog.checkTableNameIdentifier(ident);
        List reqs = Arrays.stream(changes).map(DTOConverters::toTableUpdateRequest).collect(Collectors.toList());
        TableUpdatesRequest updatesRequest = new TableUpdatesRequest(reqs);
        updatesRequest.validate();
        Namespace fullNamespace = this.getTableFullNamespace(ident.namespace());
        TableResponse resp = this.restClient.put(RelationalCatalog.formatTableRequestPath(fullNamespace) + "/" + RESTUtils.encodeString((String)ident.name()), (RESTRequest)updatesRequest, TableResponse.class, Collections.emptyMap(), ErrorHandlers.tableErrorHandler());
        resp.validate();
        return RelationalTable.from(fullNamespace, resp.getTable(), this.restClient);
    }

    public boolean dropTable(NameIdentifier ident) {
        RelationalCatalog.checkTableNameIdentifier(ident);
        Namespace fullNamespace = this.getTableFullNamespace(ident.namespace());
        DropResponse resp = this.restClient.delete(RelationalCatalog.formatTableRequestPath(fullNamespace) + "/" + RESTUtils.encodeString((String)ident.name()), DropResponse.class, Collections.emptyMap(), ErrorHandlers.tableErrorHandler());
        resp.validate();
        return resp.dropped();
    }

    public boolean purgeTable(NameIdentifier ident) throws UnsupportedOperationException {
        RelationalCatalog.checkTableNameIdentifier(ident);
        Namespace fullNamespace = this.getTableFullNamespace(ident.namespace());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("purge", "true");
        DropResponse resp = this.restClient.delete(RelationalCatalog.formatTableRequestPath(fullNamespace) + "/" + RESTUtils.encodeString((String)ident.name()), params, DropResponse.class, Collections.emptyMap(), ErrorHandlers.tableErrorHandler());
        resp.validate();
        return resp.dropped();
    }

    @VisibleForTesting
    static String formatTableRequestPath(Namespace ns) {
        Namespace schemaNs = Namespace.of((String[])new String[]{ns.level(0), ns.level(1)});
        return RelationalCatalog.formatSchemaRequestPath(schemaNs) + "/" + RESTUtils.encodeString((String)ns.level(2)) + "/tables";
    }

    static void checkTableNamespace(Namespace namespace) {
        Namespace.check((namespace != null && namespace.length() == 1 ? 1 : 0) != 0, (String)"Table namespace must be non-null and have 1 level, the input namespace is %s", (Object[])new Object[]{namespace});
    }

    static void checkTableNameIdentifier(NameIdentifier ident) {
        NameIdentifier.check((ident != null ? 1 : 0) != 0, (String)"NameIdentifier must not be null", (Object[])new Object[0]);
        NameIdentifier.check((ident.name() != null && !ident.name().isEmpty() ? 1 : 0) != 0, (String)"NameIdentifier name must not be empty", (Object[])new Object[0]);
        RelationalCatalog.checkTableNamespace(ident.namespace());
    }

    private Namespace getTableFullNamespace(Namespace tableNamespace) {
        return Namespace.of((String[])new String[]{this.catalogNamespace().level(0), this.name(), tableNamespace.level(0)});
    }

    public static Builder builder() {
        return new Builder();
    }

    static class Builder
    extends CatalogDTO.Builder<Builder> {
        private RESTClient restClient;
        private Namespace namespace;

        protected Builder() {
        }

        Builder withNamespace(Namespace namespace) {
            this.namespace = namespace;
            return this;
        }

        Builder withRestClient(RESTClient restClient) {
            this.restClient = restClient;
            return this;
        }

        public RelationalCatalog build() {
            Namespace.check((this.namespace != null && this.namespace.length() == 1 ? 1 : 0) != 0, (String)"Catalog namespace must be non-null and have 1 level, the input namespace is %s", (Object[])new Object[]{this.namespace});
            Preconditions.checkArgument((this.restClient != null ? 1 : 0) != 0, (Object)"restClient must be set");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.name), (Object)"name must not be blank");
            Preconditions.checkArgument((this.type != null ? 1 : 0) != 0, (Object)"type must not be null");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.provider), (Object)"provider must not be blank");
            Preconditions.checkArgument((this.audit != null ? 1 : 0) != 0, (Object)"audit must not be null");
            return new RelationalCatalog(this.namespace, this.name, this.type, this.provider, this.comment, this.properties, this.audit, this.restClient);
        }
    }
}

