/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import java.util.Collections;
import java.util.Locale;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.client.ErrorHandlers;
import org.apache.gravitino.client.RESTClient;
import org.apache.gravitino.credential.Credential;
import org.apache.gravitino.credential.SupportsCredentials;
import org.apache.gravitino.dto.credential.CredentialDTO;
import org.apache.gravitino.dto.responses.CredentialResponse;
import org.apache.gravitino.dto.util.DTOConverters;

class MetadataObjectCredentialOperations
implements SupportsCredentials {
    private final RESTClient restClient;
    private final String credentialRequestPath;

    MetadataObjectCredentialOperations(String metalakeName, MetadataObject metadataObject, RESTClient restClient) {
        this.restClient = restClient;
        this.credentialRequestPath = String.format("api/metalakes/%s/objects/%s/%s/credentials", metalakeName, metadataObject.type().name().toLowerCase(Locale.ROOT), metadataObject.fullName());
    }

    public Credential[] getCredentials() {
        CredentialResponse resp = this.restClient.get(this.credentialRequestPath, CredentialResponse.class, Collections.emptyMap(), ErrorHandlers.credentialErrorHandler());
        resp.validate();
        return DTOConverters.fromDTO((CredentialDTO[])resp.getCredentials());
    }
}

