/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.service.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.gravitino.iceberg.service.IcebergObjectMapper;
import org.apache.gravitino.iceberg.service.IcebergRestUtils;
import org.apache.gravitino.iceberg.service.dispatcher.IcebergViewOperationDispatcher;
import org.apache.gravitino.listener.api.event.IcebergRequestContext;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.rest.RESTUtil;
import org.apache.iceberg.rest.requests.CreateViewRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.apache.iceberg.rest.responses.LoadViewResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/{prefix:([^/]*/)?}namespaces/{namespace}/views")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IcebergViewOperations {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergViewOperations.class);
    private ObjectMapper icebergObjectMapper;
    private IcebergViewOperationDispatcher viewOperationDispatcher;
    @Context
    private HttpServletRequest httpRequest;

    @Inject
    public IcebergViewOperations(IcebergViewOperationDispatcher viewOperationDispatcher) {
        this.viewOperationDispatcher = viewOperationDispatcher;
        this.icebergObjectMapper = IcebergObjectMapper.getInstance();
    }

    @GET
    @Produces(value={"application/json"})
    @Timed(name="list-view.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="list-view", absolute=true)
    public Response listView(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace) {
        String catalogName = IcebergRestUtils.getCatalogName(prefix);
        Namespace icebergNS = RESTUtil.decodeNamespace((String)namespace);
        LOG.info("List Iceberg views, catalog: {}, namespace: {}", (Object)catalogName, (Object)icebergNS);
        IcebergRequestContext context = new IcebergRequestContext(this.httpServletRequest(), catalogName);
        ListTablesResponse listTablesResponse = this.viewOperationDispatcher.listView(context, icebergNS);
        return IcebergRestUtils.ok(listTablesResponse);
    }

    @POST
    @Produces(value={"application/json"})
    @Timed(name="create-view.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="create-view", absolute=true)
    public Response createView(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, CreateViewRequest createViewRequest) {
        String catalogName = IcebergRestUtils.getCatalogName(prefix);
        Namespace icebergNS = RESTUtil.decodeNamespace((String)namespace);
        LOG.info("Create Iceberg view, catalog: {}, namespace: {}, createViewRequest: {}", new Object[]{catalogName, icebergNS, createViewRequest});
        IcebergRequestContext context = new IcebergRequestContext(this.httpServletRequest(), catalogName);
        LoadViewResponse loadViewResponse = this.viewOperationDispatcher.createView(context, icebergNS, createViewRequest);
        return IcebergRestUtils.ok(loadViewResponse);
    }

    @GET
    @Path(value="{view}")
    @Produces(value={"application/json"})
    @Timed(name="load-view.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="load-view", absolute=true)
    public Response loadView(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @PathParam(value="view") String view) {
        String catalogName = IcebergRestUtils.getCatalogName(prefix);
        Namespace icebergNS = RESTUtil.decodeNamespace((String)namespace);
        LOG.info("Load Iceberg view, catalog: {}, namespace: {}, view: {}", new Object[]{catalogName, icebergNS, view});
        TableIdentifier viewIdentifier = TableIdentifier.of((Namespace)icebergNS, (String)view);
        IcebergRequestContext context = new IcebergRequestContext(this.httpServletRequest(), catalogName);
        LoadViewResponse loadViewResponse = this.viewOperationDispatcher.loadView(context, viewIdentifier);
        return IcebergRestUtils.ok(loadViewResponse);
    }

    @POST
    @Path(value="{view}")
    @Produces(value={"application/json"})
    @Timed(name="replace-view.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="replace-view", absolute=true)
    public Response replaceView(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @PathParam(value="view") String view, UpdateTableRequest replaceViewRequest) {
        String catalogName = IcebergRestUtils.getCatalogName(prefix);
        Namespace icebergNS = RESTUtil.decodeNamespace((String)namespace);
        LOG.info("Replace Iceberg view, catalog: {}, namespace: {}, view: {}, replaceViewRequest: {}", new Object[]{catalogName, icebergNS, view, this.SerializeReplaceViewRequest(replaceViewRequest)});
        IcebergRequestContext context = new IcebergRequestContext(this.httpServletRequest(), catalogName);
        TableIdentifier viewIdentifier = TableIdentifier.of((Namespace)icebergNS, (String)view);
        LoadViewResponse loadViewResponse = this.viewOperationDispatcher.replaceView(context, viewIdentifier, replaceViewRequest);
        return IcebergRestUtils.ok(loadViewResponse);
    }

    @DELETE
    @Path(value="{view}")
    @Produces(value={"application/json"})
    @Timed(name="drop-view.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="drop-view", absolute=true)
    public Response dropView(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @PathParam(value="view") String view) {
        String catalogName = IcebergRestUtils.getCatalogName(prefix);
        Namespace icebergNS = RESTUtil.decodeNamespace((String)namespace);
        LOG.info("Drop Iceberg view, catalog: {}, namespace: {}, view: {}", new Object[]{catalogName, icebergNS, view});
        TableIdentifier viewIdentifier = TableIdentifier.of((String[])new String[]{namespace, view});
        IcebergRequestContext context = new IcebergRequestContext(this.httpServletRequest(), catalogName);
        this.viewOperationDispatcher.dropView(context, viewIdentifier);
        return IcebergRestUtils.noContent();
    }

    @HEAD
    @Path(value="{view}")
    @Produces(value={"application/json"})
    @Timed(name="view-exists.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="view-exits", absolute=true)
    public Response viewExists(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @PathParam(value="view") String view) {
        String catalogName = IcebergRestUtils.getCatalogName(prefix);
        Namespace icebergNS = RESTUtil.decodeNamespace((String)namespace);
        LOG.info("Check Iceberg view exists, catalog: {}, namespace: {}, view: {}", new Object[]{catalogName, icebergNS, view});
        IcebergRequestContext context = new IcebergRequestContext(this.httpServletRequest(), catalogName);
        TableIdentifier viewIdentifier = TableIdentifier.of((Namespace)icebergNS, (String)view);
        boolean exists = this.viewOperationDispatcher.viewExists(context, viewIdentifier);
        if (exists) {
            return IcebergRestUtils.noContent();
        }
        return IcebergRestUtils.notExists();
    }

    @VisibleForTesting
    HttpServletRequest httpServletRequest() {
        return this.httpRequest;
    }

    private String SerializeReplaceViewRequest(UpdateTableRequest replaceViewRequest) {
        try {
            return this.icebergObjectMapper.writeValueAsString((Object)replaceViewRequest);
        }
        catch (JsonProcessingException e) {
            LOG.warn("Serialize update view request failed", (Throwable)e);
            return replaceViewRequest.toString();
        }
    }
}

