/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.common.authentication.kerberos;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.config.ConfigBuilder;
import org.apache.gravitino.config.ConfigEntry;
import org.apache.gravitino.connector.PropertyEntry;
import org.apache.gravitino.iceberg.common.authentication.AuthenticationConfig;

public class KerberosConfig
extends AuthenticationConfig {
    public static final String KET_TAB_URI_KEY = "authentication.kerberos.keytab-uri";
    public static final String PRINCIPAL_KEY = "authentication.kerberos.principal";
    public static final String CHECK_INTERVAL_SEC_KEY = "authentication.kerberos.check-interval-sec";
    public static final String FETCH_TIMEOUT_SEC_KEY = "authentication.kerberos.keytab-fetch-timeout-sec";
    public static final String GRAVITINO_KEYTAB_FORMAT = "keytabs/gravitino-lakehouse-iceberg-%s-keytab";
    public static final ConfigEntry<String> PRINCIPAL_ENTRY = new ConfigBuilder("authentication.kerberos.principal").doc("The principal of the Kerberos for Iceberg catalog with Kerberos authentication").version("0.6.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> KEYTAB_ENTRY = new ConfigBuilder("authentication.kerberos.keytab-uri").doc("The keytab of the Kerberos for Iceberg catalog with Kerberos authentication").version("0.6.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<Integer> CHECK_INTERVAL_SEC_ENTRY = new ConfigBuilder("authentication.kerberos.check-interval-sec").doc("The check interval of the Kerberos credential for Iceberg catalog with Kerberos authentication").version("0.6.0").intConf().checkValue(value -> value > 0, "The value must be a positive number").createWithDefault((Object)2);
    public static final ConfigEntry<Integer> FETCH_TIMEOUT_SEC_ENTRY = new ConfigBuilder("authentication.kerberos.keytab-fetch-timeout-sec").doc("The fetch timeout of the Kerberos key table of Iceberg catalog with Kerberos authentication").version("0.6.0").intConf().checkValue(value -> value > 0, "The value must be a positive number").createWithDefault((Object)2);
    public static final Map<String, PropertyEntry<?>> KERBEROS_PROPERTY_ENTRIES = new ImmutableMap.Builder().put((Object)"authentication.kerberos.keytab-uri", (Object)PropertyEntry.stringOptionalPropertyEntry((String)"authentication.kerberos.keytab-uri", (String)"The keytab of the Kerberos for Iceberg catalog with Kerberos authentication", (boolean)false, null, (boolean)false)).put((Object)"authentication.kerberos.principal", (Object)PropertyEntry.stringOptionalPropertyEntry((String)"authentication.kerberos.principal", (String)"The principal of the Kerberos for Iceberg catalog with Kerberos authentication", (boolean)false, null, (boolean)false)).put((Object)"authentication.kerberos.check-interval-sec", (Object)PropertyEntry.integerOptionalPropertyEntry((String)"authentication.kerberos.check-interval-sec", (String)"The check interval of the Kerberos credential for Iceberg catalog with Kerberos authentication", (boolean)false, (Integer)60, (boolean)false)).put((Object)"authentication.kerberos.keytab-fetch-timeout-sec", (Object)PropertyEntry.integerOptionalPropertyEntry((String)"authentication.kerberos.keytab-fetch-timeout-sec", (String)"The fetch timeout of the Kerberos key table of Iceberg catalog with Kerberos authentication", (boolean)false, (Integer)60, (boolean)false)).build();

    public KerberosConfig(Map<String, String> properties) {
        super(properties);
        this.loadFromMap(properties, k -> true);
    }

    @Override
    public boolean isImpersonationEnabled() {
        return (Boolean)this.get(ENABLE_IMPERSONATION_ENTRY);
    }

    public String getPrincipalName() {
        return (String)this.get(PRINCIPAL_ENTRY);
    }

    public String getKeytab() {
        return (String)this.get(KEYTAB_ENTRY);
    }

    public int getCheckIntervalSec() {
        return (Integer)this.get(CHECK_INTERVAL_SEC_ENTRY);
    }

    public int getFetchTimeoutSec() {
        return (Integer)this.get(FETCH_TIMEOUT_SEC_ENTRY);
    }
}

