/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.iceberg;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public class IcebergPropertiesUtils {
    public static final Map<String, String> GRAVITINO_CONFIG_TO_ICEBERG;

    public static Map<String, String> toIcebergCatalogProperties(Map<String, String> gravitinoProperties) {
        HashMap<String, String> icebergProperties = new HashMap<String, String>();
        gravitinoProperties.forEach((key, value) -> {
            if (GRAVITINO_CONFIG_TO_ICEBERG.containsKey(key)) {
                icebergProperties.put(GRAVITINO_CONFIG_TO_ICEBERG.get(key), (String)value);
            }
        });
        return icebergProperties;
    }

    public static String getCatalogBackendName(Map<String, String> catalogProperties) {
        String backendName = catalogProperties.get("catalog-backend-name");
        if (backendName != null) {
            return backendName;
        }
        String catalogBackend = catalogProperties.get("catalog-backend");
        return Optional.ofNullable(catalogBackend).map(s -> s.toLowerCase(Locale.ROOT)).orElse("memory");
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("catalog-backend", "catalog-backend");
        map.put("catalog-backend-impl", "catalog-backend-impl");
        map.put("jdbc-driver", "jdbc-driver");
        map.put("jdbc-user", "jdbc.user");
        map.put("jdbc-password", "jdbc.password");
        map.put("uri", "uri");
        map.put("warehouse", "warehouse");
        map.put("catalog-backend-name", "catalog-backend-name");
        map.put("io-impl", "io-impl");
        map.put("s3-endpoint", "s3.endpoint");
        map.put("s3-region", "client.region");
        map.put("s3-access-key-id", "s3.access-key-id");
        map.put("s3-secret-access-key", "s3.secret-access-key");
        map.put("oss-endpoint", "oss.endpoint");
        map.put("oss-access-key-id", "client.access-key-id");
        map.put("oss-secret-access-key", "client.access-key-secret");
        map.put("azure-storage-account-name", "adls.auth.shared-key.account.name");
        map.put("azure-storage-account-key", "adls.auth.shared-key.account.key");
        GRAVITINO_CONFIG_TO_ICEBERG = Collections.unmodifiableMap(map);
    }
}

