/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.base;

import java.util.List;
import org.apache.gravitino.storage.relational.po.ColumnPO;
import org.apache.ibatis.annotations.Param;

public class TableColumnBaseSQLProvider {
    public String listColumnPOsByTableIdAndVersion(@Param(value="tableId") Long tableId, @Param(value="tableVersion") Long tableVersion) {
        return "SELECT t1.column_id AS columnId, t1.column_name AS columnName, t1.column_position AS columnPosition, t1.metalake_id AS metalakeId, t1.catalog_id AS catalogId, t1.schema_id AS schemaId, t1.table_id AS tableId, t1.table_version AS tableVersion, t1.column_type AS columnType, t1.column_comment AS columnComment, t1.column_nullable AS nullable, t1.column_auto_increment AS autoIncrement, t1.column_default_value AS defaultValue, t1.column_op_type AS columnOpType, t1.deleted_at AS deletedAt, t1.audit_info AS auditInfo FROM table_column_version_info t1 JOIN ( SELECT column_id, MAX(table_version) AS max_table_version FROM table_column_version_info WHERE table_id = #{tableId} AND table_version <= #{tableVersion} AND deleted_at = 0 GROUP BY column_id) t2 ON t1.column_id = t2.column_id AND t1.table_version = t2.max_table_version";
    }

    public String insertColumnPOs(@Param(value="columnPOs") List<ColumnPO> columnPOs) {
        return "<script>INSERT INTO table_column_version_info(column_id, column_name, column_position, metalake_id, catalog_id, schema_id, table_id, table_version, column_type, column_comment, column_nullable, column_auto_increment, column_default_value, column_op_type, deleted_at, audit_info) VALUES <foreach collection='columnPOs' item='item' separator=','>(#{item.columnId}, #{item.columnName}, #{item.columnPosition}, #{item.metalakeId}, #{item.catalogId}, #{item.schemaId}, #{item.tableId}, #{item.tableVersion}, #{item.columnType}, #{item.columnComment}, #{item.nullable}, #{item.autoIncrement}, #{item.defaultValue}, #{item.columnOpType}, #{item.deletedAt}, #{item.auditInfo})</foreach></script>";
    }

    public String softDeleteColumnsByTableId(@Param(value="tableId") Long tableId) {
        return "UPDATE table_column_version_info SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE table_id = #{tableId} AND deleted_at = 0";
    }

    public String softDeleteColumnsByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return "UPDATE table_column_version_info SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE metalake_id = #{metalakeId} AND deleted_at = 0";
    }

    public String softDeleteColumnsByCatalogId(@Param(value="catalogId") Long catalogId) {
        return "UPDATE table_column_version_info SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE catalog_id = #{catalogId} AND deleted_at = 0";
    }

    public String softDeleteColumnsBySchemaId(@Param(value="schemaId") Long schemaId) {
        return "UPDATE table_column_version_info SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE schema_id = #{schemaId} AND deleted_at = 0";
    }

    public String deleteColumnPOsByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return "DELETE FROM table_column_version_info WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit}";
    }

    public String selectColumnIdByTableIdAndName(@Param(value="tableId") Long tableId, @Param(value="columnName") String name) {
        return "SELECT   CASE     WHEN column_op_type = 3 THEN NULL     ELSE column_id   END FROM table_column_version_info WHERE table_id = #{tableId} AND column_name = #{columnName} AND deleted_at = 0 ORDER BY table_version DESC LIMIT 1";
    }

    public String selectColumnPOById(@Param(value="columnId") Long columnId) {
        return "SELECT column_id AS columnId, column_name AS columnName, column_position AS columnPosition, metalake_id AS metalakeId, catalog_id AS catalogId, schema_id AS schemaId, table_id AS tableId, table_version AS tableVersion, column_type AS columnType, column_comment AS columnComment, column_nullable AS nullable, column_auto_increment AS autoIncrement, column_default_value AS defaultValue, column_op_type AS columnOpType, deleted_at AS deletedAt, audit_info AS auditInfo FROM table_column_version_info WHERE column_id = #{columnId} AND deleted_at = 0 ORDER BY table_version DESC LIMIT 1";
    }
}

