/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.messaging;

import java.util.Objects;
import org.apache.gravitino.annotation.Evolving;

@Evolving
public interface TopicChange {
    public static TopicChange updateComment(String newComment) {
        return new UpdateTopicComment(newComment);
    }

    public static TopicChange setProperty(String property, String value) {
        return new SetProperty(property, value);
    }

    public static TopicChange removeProperty(String property) {
        return new RemoveProperty(property);
    }

    public static final class RemoveProperty
    implements TopicChange {
        private final String property;

        private RemoveProperty(String property) {
            this.property = property;
        }

        public String getProperty() {
            return this.property;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemoveProperty that = (RemoveProperty)o;
            return Objects.equals(this.property, that.property);
        }

        public int hashCode() {
            return Objects.hash(this.property);
        }

        public String toString() {
            return "REMOVEPROPERTY " + this.property;
        }
    }

    public static final class SetProperty
    implements TopicChange {
        private final String property;
        private final String value;

        private SetProperty(String property, String value) {
            this.property = property;
            this.value = value;
        }

        public String getProperty() {
            return this.property;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SetProperty that = (SetProperty)o;
            return Objects.equals(this.property, that.property) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.property, this.value);
        }

        public String toString() {
            return "SETPROPERTY " + this.property + " " + this.value;
        }
    }

    public static final class UpdateTopicComment
    implements TopicChange {
        private final String newComment;

        private UpdateTopicComment(String newComment) {
            this.newComment = newComment;
        }

        public String getNewComment() {
            return this.newComment;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UpdateTopicComment that = (UpdateTopicComment)o;
            return Objects.equals(this.newComment, that.newComment);
        }

        public int hashCode() {
            return Objects.hash(this.newComment);
        }

        public String toString() {
            return "UPDATETOPICCOMMENT " + this.newComment;
        }
    }
}

