/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.service.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.gravitino.iceberg.common.ops.IcebergTableOps;
import org.apache.gravitino.iceberg.service.IcebergRestUtils;
import org.apache.iceberg.rest.requests.RenameTableRequest;

@Path(value="/v1/{prefix:([^/]*/)?}tables/rename")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IcebergTableRenameOperations {
    @Context
    private HttpServletRequest httpRequest;
    private IcebergTableOps icebergTableOps;

    @Inject
    public IcebergTableRenameOperations(IcebergTableOps icebergTableOps) {
        this.icebergTableOps = icebergTableOps;
    }

    @POST
    @Produces(value={"application/json"})
    @Timed(name="rename-table.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="rename-table", absolute=true)
    public Response renameTable(RenameTableRequest renameTableRequest) {
        this.icebergTableOps.renameTable(renameTableRequest);
        return IcebergRestUtils.okWithoutContent();
    }
}

