/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.flush;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.flush.FlushProcess;
import org.datanucleus.flush.OperationQueue;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.StorePersistenceHandler;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class FlushNonReferential
implements FlushProcess {
    @Override
    public List<NucleusOptimisticException> execute(ExecutionContext ec, List<ObjectProvider> primaryOPs, List<ObjectProvider> secondaryOPs, OperationQueue opQueue) {
        HashSet<ObjectProvider> opsToFlush = new HashSet<ObjectProvider>();
        if (primaryOPs != null) {
            opsToFlush.addAll(primaryOPs);
            primaryOPs.clear();
        }
        if (secondaryOPs != null) {
            opsToFlush.addAll(secondaryOPs);
            secondaryOPs.clear();
        }
        List<NucleusOptimisticException> excptns = this.flushDeleteInsertUpdateGrouped(opsToFlush, ec);
        if (opQueue != null) {
            if (!ec.getStoreManager().usesBackedSCOWrappers()) {
                opQueue.processOperationsForNoBackingStoreSCOs(ec);
            }
            opQueue.clearPersistDeleteUpdateOperations();
        }
        return excptns;
    }

    public List<NucleusOptimisticException> flushDeleteInsertUpdateGrouped(Set<ObjectProvider> opsToFlush, ExecutionContext ec) {
        ArrayList<NucleusOptimisticException> optimisticFailures = null;
        HashSet classesToFlush = null;
        if (ec.getNucleusContext().getStoreManager().getQueryManager().getQueryResultsCache() != null) {
            classesToFlush = new HashSet();
        }
        HashSet<ObjectProvider> opsToDelete = new HashSet<ObjectProvider>();
        HashSet<ObjectProvider> opsToInsert = new HashSet<ObjectProvider>();
        Iterator<ObjectProvider> opIter = opsToFlush.iterator();
        while (opIter.hasNext()) {
            ObjectProvider op = opIter.next();
            if (op.isEmbedded()) {
                op.markAsFlushed();
                opIter.remove();
                continue;
            }
            if (classesToFlush != null && op.getObject() != null) {
                classesToFlush.add(op.getObject().getClass());
            }
            if (op.getLifecycleState().isNew() && !op.isFlushedToDatastore() && !op.isFlushedNew()) {
                opsToInsert.add(op);
                opIter.remove();
                continue;
            }
            if (!op.getLifecycleState().isDeleted() || op.isFlushedToDatastore()) continue;
            if (!op.getLifecycleState().isNew()) {
                opsToDelete.add(op);
                opIter.remove();
                continue;
            }
            if (!op.getLifecycleState().isNew() || !op.isFlushedNew()) continue;
            opsToDelete.add(op);
            opIter.remove();
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("010046", opsToDelete.size(), opsToInsert.size(), opsToFlush.size()));
        }
        StorePersistenceHandler persistenceHandler = ec.getStoreManager().getPersistenceHandler();
        if (!opsToDelete.isEmpty()) {
            for (ObjectProvider objectProvider : opsToDelete) {
                objectProvider.setFlushing(true);
                ec.getCallbackHandler().preDelete(objectProvider.getObject());
            }
            try {
                persistenceHandler.deleteObjects(opsToDelete.toArray(new ObjectProvider[opsToDelete.size()]));
            }
            catch (NucleusOptimisticException noe) {
                optimisticFailures = new ArrayList<NucleusOptimisticException>();
                Throwable[] throwableArray = noe.getNestedExceptions();
                if (throwableArray != null && throwableArray.length > 1) {
                    NucleusOptimisticException[] noes = (NucleusOptimisticException[])throwableArray;
                    for (int i = 0; i < throwableArray.length; ++i) {
                        optimisticFailures.add(noes[i]);
                    }
                }
                optimisticFailures.add(noe);
            }
            for (ObjectProvider objectProvider : opsToDelete) {
                ec.getCallbackHandler().postDelete(objectProvider.getObject());
                objectProvider.setFlushedNew(false);
                objectProvider.markAsFlushed();
                objectProvider.setFlushing(false);
            }
        }
        if (!opsToInsert.isEmpty()) {
            for (ObjectProvider objectProvider : opsToInsert) {
                objectProvider.setFlushing(true);
                ec.getCallbackHandler().preStore(objectProvider.getObject());
            }
            persistenceHandler.insertObjects(opsToInsert.toArray(new ObjectProvider[opsToInsert.size()]));
            for (ObjectProvider objectProvider : opsToInsert) {
                ec.getCallbackHandler().postStore(objectProvider.getObject());
                objectProvider.setFlushedNew(true);
                objectProvider.markAsFlushed();
                objectProvider.setFlushing(false);
                ec.putObjectIntoLevel1Cache(objectProvider);
            }
        }
        if (!opsToFlush.isEmpty()) {
            for (ObjectProvider objectProvider : opsToFlush) {
                try {
                    objectProvider.flush();
                }
                catch (NucleusOptimisticException oe) {
                    if (optimisticFailures == null) {
                        optimisticFailures = new ArrayList();
                    }
                    optimisticFailures.add(oe);
                }
            }
        }
        if (classesToFlush != null) {
            for (Class clazz : classesToFlush) {
                ec.getNucleusContext().getStoreManager().getQueryManager().evictQueryResultsForType(clazz);
            }
        }
        return optimisticFailures;
    }
}

