/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.schema;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.rdbms.schema.RDBMSColumnInfo;
import org.datanucleus.store.schema.ListStoreSchemaData;
import org.datanucleus.store.schema.StoreSchemaData;

public class RDBMSTableInfo
implements ListStoreSchemaData {
    private int hash = 0;
    Map<String, Object> properties = new HashMap<String, Object>();
    List columns = new ArrayList();
    Map<String, StoreSchemaData> columnMapByColumnName = new HashMap<String, StoreSchemaData>();

    public RDBMSTableInfo() {
    }

    public RDBMSTableInfo(String catalog, String schema, String table) {
        this.addProperty("table_cat", catalog);
        this.addProperty("table_schem", schema);
        this.addProperty("table_name", table);
    }

    public RDBMSTableInfo(ResultSet rs) {
        try {
            this.addProperty("table_cat", rs.getString(1));
            this.addProperty("table_schem", rs.getString(2));
            this.addProperty("table_name", rs.getString(3));
            this.addProperty("table_type", rs.getString(4));
            this.addProperty("remarks", rs.getString(5));
            if (rs.getMetaData().getColumnCount() > 5) {
                this.addProperty("type_cat", rs.getString(6));
                this.addProperty("type_schem", rs.getString(7));
                this.addProperty("type_name", rs.getString(8));
                this.addProperty("self_referencing_col_name", rs.getString(9));
                this.addProperty("ref_generation", rs.getString(10));
            }
        }
        catch (SQLException sqle) {
            throw new NucleusDataStoreException("Exception thrown obtaining schema table information from datastore", (Throwable)sqle);
        }
    }

    public void addChild(StoreSchemaData child) {
        RDBMSColumnInfo col = (RDBMSColumnInfo)child;
        this.columns.add(col);
        this.columnMapByColumnName.put(col.getColumnName(), child);
    }

    public void clearChildren() {
        this.columns.clear();
        this.columnMapByColumnName.clear();
    }

    public StoreSchemaData getChild(int position) {
        return (StoreSchemaData)this.columns.get(position);
    }

    public StoreSchemaData getChild(String key) {
        return this.columnMapByColumnName.get(key);
    }

    public List getChildren() {
        return this.columns;
    }

    public int getNumberOfChildren() {
        return this.columns.size();
    }

    public void addProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public StoreSchemaData getParent() {
        return null;
    }

    public void setParent(StoreSchemaData parent) {
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RDBMSTableInfo)) {
            return false;
        }
        RDBMSTableInfo other = (RDBMSTableInfo)obj;
        String cat1 = (String)this.getProperty("table_cat");
        String sch1 = (String)this.getProperty("table_schem");
        String name1 = (String)this.getProperty("table_name");
        String cat2 = (String)other.getProperty("table_cat");
        String sch2 = (String)other.getProperty("table_schem");
        String name2 = (String)other.getProperty("table_name");
        return (cat1 == null ? cat2 == null : cat1.equals(cat2)) && (sch1 == null ? sch2 == null : sch1.equals(sch2)) && name1.equals(name2);
    }

    public final int hashCode() {
        if (this.hash == 0) {
            String cat = (String)this.getProperty("table_cat");
            String sch = (String)this.getProperty("table_schem");
            String name = (String)this.getProperty("table_name");
            this.hash = (cat == null ? 0 : cat.hashCode()) ^ (sch == null ? 0 : sch.hashCode()) ^ name.hashCode();
        }
        return this.hash;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("RDBMSTableInfo : ");
        Iterator<Map.Entry<String, Object>> iter = this.properties.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Object> entry = iter.next();
            str.append(entry.getKey() + " = " + entry.getValue());
            if (!iter.hasNext()) continue;
            str.append(", ");
        }
        str.append(", numColumns=" + this.columns.size());
        return str.toString();
    }
}

