/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.storage.relational.JDBCBackend;
import org.apache.gravitino.storage.relational.mapper.provider.base.GroupRoleRelBaseSQLProvider;
import org.apache.gravitino.storage.relational.po.GroupRoleRelPO;
import org.apache.gravitino.storage.relational.session.SqlSessionFactoryHelper;
import org.apache.ibatis.annotations.Param;

public class GroupRoleRelSQLProviderFactory {
    private static final Map<JDBCBackend.JDBCBackendType, GroupRoleRelBaseSQLProvider> METALAKE_META_SQL_PROVIDER_MAP = ImmutableMap.of((Object)((Object)JDBCBackend.JDBCBackendType.MYSQL), (Object)new GroupRoleRelMySQLProvider(), (Object)((Object)JDBCBackend.JDBCBackendType.H2), (Object)new GroupRoleRelH2Provider());

    public static GroupRoleRelBaseSQLProvider getProvider() {
        String databaseId = SqlSessionFactoryHelper.getInstance().getSqlSessionFactory().getConfiguration().getDatabaseId();
        JDBCBackend.JDBCBackendType jdbcBackendType = JDBCBackend.JDBCBackendType.fromString(databaseId);
        return METALAKE_META_SQL_PROVIDER_MAP.get((Object)jdbcBackendType);
    }

    public static String batchInsertGroupRoleRel(@Param(value="groupRoleRels") List<GroupRoleRelPO> groupRoleRelPOS) {
        return GroupRoleRelSQLProviderFactory.getProvider().batchInsertGroupRoleRel(groupRoleRelPOS);
    }

    public static String batchInsertGroupRoleRelOnDuplicateKeyUpdate(@Param(value="groupRoleRels") List<GroupRoleRelPO> groupRoleRelPOS) {
        return GroupRoleRelSQLProviderFactory.getProvider().batchInsertGroupRoleRelOnDuplicateKeyUpdate(groupRoleRelPOS);
    }

    public static String softDeleteGroupRoleRelByGroupId(@Param(value="groupId") Long groupId) {
        return GroupRoleRelSQLProviderFactory.getProvider().softDeleteGroupRoleRelByGroupId(groupId);
    }

    public static String softDeleteGroupRoleRelByGroupAndRoles(@Param(value="groupId") Long groupId, @Param(value="roleIds") List<Long> roleIds) {
        return GroupRoleRelSQLProviderFactory.getProvider().softDeleteGroupRoleRelByGroupAndRoles(groupId, roleIds);
    }

    public static String softDeleteGroupRoleRelByMetalakeId(Long metalakeId) {
        return GroupRoleRelSQLProviderFactory.getProvider().softDeleteGroupRoleRelByMetalakeId(metalakeId);
    }

    public static String softDeleteGroupRoleRelByRoleId(Long roleId) {
        return GroupRoleRelSQLProviderFactory.getProvider().softDeleteGroupRoleRelByRoleId(roleId);
    }

    public static String deleteGroupRoleRelMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return GroupRoleRelSQLProviderFactory.getProvider().deleteGroupRoleRelMetasByLegacyTimeline(legacyTimeline, limit);
    }

    static class GroupRoleRelH2Provider
    extends GroupRoleRelBaseSQLProvider {
        GroupRoleRelH2Provider() {
        }
    }

    static class GroupRoleRelMySQLProvider
    extends GroupRoleRelBaseSQLProvider {
        GroupRoleRelMySQLProvider() {
        }
    }
}

