/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.kv;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.gravitino.Config;
import org.apache.gravitino.Configs;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntityAlreadyExistsException;
import org.apache.gravitino.EntitySerDe;
import org.apache.gravitino.EntitySerDeFactory;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.exceptions.NonEmptyEntityException;
import org.apache.gravitino.storage.EntityKeyEncoder;
import org.apache.gravitino.storage.FunctionUtils;
import org.apache.gravitino.storage.NameMappingService;
import org.apache.gravitino.storage.StorageLayoutVersion;
import org.apache.gravitino.storage.TransactionIdGenerator;
import org.apache.gravitino.storage.kv.BinaryEntityEncoderUtil;
import org.apache.gravitino.storage.kv.BinaryEntityKeyEncoder;
import org.apache.gravitino.storage.kv.KvBackend;
import org.apache.gravitino.storage.kv.KvGarbageCollector;
import org.apache.gravitino.storage.kv.KvNameMappingService;
import org.apache.gravitino.storage.kv.KvRange;
import org.apache.gravitino.storage.kv.RocksDBKvBackend;
import org.apache.gravitino.storage.kv.TransactionIdGeneratorImpl;
import org.apache.gravitino.storage.kv.TransactionalKvBackend;
import org.apache.gravitino.storage.kv.TransactionalKvBackendImpl;
import org.apache.gravitino.utils.Bytes;
import org.apache.gravitino.utils.Executable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KvEntityStore
implements EntityStore {
    private static final String NO_SUCH_ENTITY_MSG = "No such entity:%s";
    public static final Logger LOGGER = LoggerFactory.getLogger(KvEntityStore.class);
    public static final ImmutableMap<String, String> KV_BACKENDS = ImmutableMap.of((Object)"RocksDBKvBackend", (Object)RocksDBKvBackend.class.getCanonicalName());
    public static final byte[] LAYOUT_VERSION_KEY = Bytes.concat({29, 0, 2}, "layout_version".getBytes(StandardCharsets.UTF_8));
    @VisibleForTesting
    KvBackend backend;
    private ReentrantReadWriteLock reentrantReadWriteLock;
    @VisibleForTesting
    EntityKeyEncoder<byte[]> entityKeyEncoder;
    @VisibleForTesting
    NameMappingService nameMappingService;
    private EntitySerDe serDe;
    @VisibleForTesting
    StorageLayoutVersion storageLayoutVersion;
    private TransactionIdGenerator txIdGenerator;
    @VisibleForTesting
    KvGarbageCollector kvGarbageCollector;
    private TransactionalKvBackend transactionalKvBackend;

    @Override
    public void initialize(Config config) throws RuntimeException {
        this.backend = KvEntityStore.createKvEntityBackend(config);
        this.txIdGenerator = new TransactionIdGeneratorImpl(this.backend, config);
        this.txIdGenerator.start();
        this.transactionalKvBackend = new TransactionalKvBackendImpl(this.backend, this.txIdGenerator);
        this.reentrantReadWriteLock = new ReentrantReadWriteLock();
        this.nameMappingService = new KvNameMappingService(this.transactionalKvBackend, this.reentrantReadWriteLock);
        this.entityKeyEncoder = new BinaryEntityKeyEncoder(this.nameMappingService);
        this.kvGarbageCollector = new KvGarbageCollector(this.backend, config, this.entityKeyEncoder);
        this.kvGarbageCollector.start();
        this.storageLayoutVersion = this.initStorageVersionInfo();
        this.serDe = EntitySerDeFactory.createEntitySerDe(config);
    }

    @Override
    public void setSerDe(EntitySerDe entitySerDe) {
        this.serDe = entitySerDe;
    }

    @Override
    public <E extends Entity & HasIdentifier> List<E> list(Namespace namespace, Class<E> e, Entity.EntityType type) throws IOException {
        ArrayList entities = Lists.newArrayList();
        NameIdentifier identifier = NameIdentifier.of((Namespace)namespace, (String)"*");
        byte[] startKey = this.entityKeyEncoder.encode(identifier, type, true);
        if (startKey == null) {
            return entities;
        }
        byte[] endKey = Bytes.increment(Bytes.wrap(startKey)).get();
        List kvs = this.executeInTransaction(() -> this.transactionalKvBackend.scan(new KvRange.KvRangeBuilder().start(startKey).end(endKey).startInclusive(true).endInclusive(false).limit(Integer.MAX_VALUE).build()));
        for (Pair pairs : kvs) {
            entities.add(this.serDe.deserialize((byte[])pairs.getRight(), e, namespace));
        }
        return entities;
    }

    @Override
    public boolean exists(NameIdentifier ident, Entity.EntityType entityType) throws IOException {
        return this.executeInTransaction(() -> {
            byte[] key = this.entityKeyEncoder.encode(ident, entityType, true);
            if (key == null) {
                return false;
            }
            return this.transactionalKvBackend.get(key) != null;
        });
    }

    @Override
    public <E extends Entity & HasIdentifier> void put(E e, boolean overwritten) throws IOException, EntityAlreadyExistsException {
        this.executeInTransaction(() -> {
            byte[] key = this.entityKeyEncoder.encode(((HasIdentifier)((Object)e)).nameIdentifier(), e.type());
            byte[] value = this.serDe.serialize(e);
            this.transactionalKvBackend.put(key, value, overwritten);
            return null;
        });
    }

    @Override
    public <E extends Entity & HasIdentifier> E update(NameIdentifier ident, Class<E> type, Entity.EntityType entityType, Function<E, E> updater) throws IOException, NoSuchEntityException, EntityAlreadyExistsException {
        return (E)this.executeInTransaction(() -> {
            byte[] key = this.entityKeyEncoder.encode(ident, entityType);
            byte[] value = this.transactionalKvBackend.get(key);
            if (value == null) {
                throw new NoSuchEntityException(NO_SUCH_ENTITY_MSG, new Object[]{ident.toString()});
            }
            Object e = this.serDe.deserialize(value, type, ident.namespace());
            Entity updatedE = (Entity)updater.apply(e);
            if (((HasIdentifier)((Object)updatedE)).nameIdentifier().equals((Object)ident)) {
                this.transactionalKvBackend.put(key, this.serDe.serialize(updatedE), true);
                return updatedE;
            }
            boolean newEntityExist = this.exists(((HasIdentifier)((Object)updatedE)).nameIdentifier(), entityType);
            if (newEntityExist) {
                throw new EntityAlreadyExistsException("Entity %s already exist, please check again", ((HasIdentifier)((Object)updatedE)).nameIdentifier());
            }
            this.nameMappingService.updateName(BinaryEntityEncoderUtil.generateKeyForMapping(ident, entityType, this.nameMappingService), BinaryEntityEncoderUtil.generateKeyForMapping(((HasIdentifier)((Object)updatedE)).nameIdentifier(), entityType, this.nameMappingService));
            this.transactionalKvBackend.put(key, this.serDe.serialize(updatedE), true);
            return updatedE;
        });
    }

    @Override
    public <E extends Entity & HasIdentifier> E get(NameIdentifier ident, Entity.EntityType entityType, Class<E> e) throws NoSuchEntityException, IOException {
        byte[] value = this.executeInTransaction(() -> {
            byte[] key = this.entityKeyEncoder.encode(ident, entityType, true);
            if (key == null) {
                throw new NoSuchEntityException(NO_SUCH_ENTITY_MSG, new Object[]{ident.toString()});
            }
            return this.transactionalKvBackend.get(key);
        });
        if (value == null) {
            throw new NoSuchEntityException(NO_SUCH_ENTITY_MSG, new Object[]{ident.toString()});
        }
        return this.serDe.deserialize(value, e, ident.namespace());
    }

    void deleteAuthorizationEntitiesIfNecessary(NameIdentifier ident, Entity.EntityType type) throws IOException {
        String[] entityShortNames;
        if (type != Entity.EntityType.METALAKE) {
            return;
        }
        byte[] encode = this.entityKeyEncoder.encode(ident, type, true);
        for (String name : entityShortNames = new String[]{Entity.EntityType.USER.getShortName(), Entity.EntityType.GROUP.getShortName(), Entity.EntityType.ROLE.getShortName()}) {
            byte[] prefix = BinaryEntityEncoderUtil.replacePrefixTypeInfo(encode, name);
            this.transactionalKvBackend.deleteRange(new KvRange.KvRangeBuilder().start(prefix).startInclusive(true).end(Bytes.increment(Bytes.wrap(prefix)).get()).build());
        }
    }

    @Override
    public boolean delete(NameIdentifier ident, Entity.EntityType entityType, boolean cascade) throws IOException {
        return this.executeInTransaction(() -> {
            if (!this.exists(ident, entityType)) {
                return false;
            }
            byte[] dataKey = this.entityKeyEncoder.encode(ident, entityType, true);
            List<byte[]> subEntityPrefix = BinaryEntityEncoderUtil.getSubEntitiesPrefix(ident, entityType, (BinaryEntityKeyEncoder)this.entityKeyEncoder);
            if (subEntityPrefix.isEmpty()) {
                return this.transactionalKvBackend.delete(dataKey);
            }
            byte[] directChild = (byte[])Iterables.getLast(subEntityPrefix);
            byte[] endKey = Bytes.increment(Bytes.wrap(directChild)).get();
            List<Pair<byte[], byte[]>> kvs = this.transactionalKvBackend.scan(new KvRange.KvRangeBuilder().start(directChild).end(endKey).startInclusive(true).endInclusive(false).limit(1).build());
            if (!cascade && !kvs.isEmpty()) {
                ArrayList subEntities = Lists.newArrayListWithCapacity((int)kvs.size());
                for (Pair<byte[], byte[]> pair : kvs) {
                    subEntities.add((NameIdentifier)this.entityKeyEncoder.decode((byte[])pair.getLeft()).getLeft());
                }
                throw new NonEmptyEntityException("Entity %s has sub-entities %s, you should remove sub-entities first", new Object[]{ident, subEntities});
            }
            this.unbindNameAndId(ident, entityType);
            return this.transactionalKvBackend.delete(dataKey);
        });
    }

    private void unbindNameAndId(NameIdentifier ident, Entity.EntityType entityType) throws IOException {
        String identNameToIdKey = BinaryEntityEncoderUtil.generateKeyForMapping(ident, entityType, this.nameMappingService);
        this.nameMappingService.unbindNameAndId(identNameToIdKey);
    }

    @Override
    public <R, E extends Exception> R executeInTransaction(Executable<R, E> executable) throws E, IOException {
        return FunctionUtils.executeInTransaction(executable, this.transactionalKvBackend);
    }

    @Override
    public void close() throws IOException {
        this.txIdGenerator.close();
        this.kvGarbageCollector.close();
        this.backend.close();
    }

    private static KvBackend createKvEntityBackend(Config config) {
        String backendName = config.get(Configs.ENTITY_KV_STORE);
        String className = (String)KV_BACKENDS.getOrDefault((Object)backendName, (Object)backendName);
        if (Objects.isNull(className)) {
            throw new RuntimeException("Unsupported backend type..." + backendName);
        }
        try {
            KvBackend kvBackend = (KvBackend)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            kvBackend.initialize(config);
            return kvBackend;
        }
        catch (Exception e) {
            LOGGER.error("Failed to create and initialize KvBackend by name '{}'.", (Object)backendName, (Object)e);
            throw new RuntimeException("Failed to create and initialize KvBackend by name: " + backendName, e);
        }
    }

    private StorageLayoutVersion initStorageVersionInfo() {
        try {
            byte[] bytes = this.backend.get(LAYOUT_VERSION_KEY);
            if (bytes == null) {
                this.backend.put(LAYOUT_VERSION_KEY, StorageLayoutVersion.V1.getVersion().getBytes(StandardCharsets.UTF_8), true);
                return StorageLayoutVersion.V1;
            }
            return StorageLayoutVersion.fromString(new String(bytes, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to get/put layout version information", e);
        }
    }

    public KvBackend getBackend() {
        return this.backend;
    }
}

