/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.proto;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.Map;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntitySerDe;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.proto.ProtoSerDe;

public class ProtoEntitySerDe
implements EntitySerDe {
    private static final Map<String, String> ENTITY_TO_SERDE = ImmutableMap.builder().put((Object)"org.apache.gravitino.meta.AuditInfo", (Object)"org.apache.gravitino.proto.AuditInfoSerDe").put((Object)"org.apache.gravitino.meta.BaseMetalake", (Object)"org.apache.gravitino.proto.BaseMetalakeSerDe").put((Object)"org.apache.gravitino.meta.CatalogEntity", (Object)"org.apache.gravitino.proto.CatalogEntitySerDe").put((Object)"org.apache.gravitino.meta.SchemaEntity", (Object)"org.apache.gravitino.proto.SchemaEntitySerDe").put((Object)"org.apache.gravitino.meta.TableEntity", (Object)"org.apache.gravitino.proto.TableEntitySerDe").put((Object)"org.apache.gravitino.meta.FilesetEntity", (Object)"org.apache.gravitino.proto.FilesetEntitySerDe").put((Object)"org.apache.gravitino.meta.TopicEntity", (Object)"org.apache.gravitino.proto.TopicEntitySerDe").put((Object)"org.apache.gravitino.meta.UserEntity", (Object)"org.apache.gravitino.proto.UserEntitySerDe").put((Object)"org.apache.gravitino.meta.GroupEntity", (Object)"org.apache.gravitino.proto.GroupEntitySerDe").put((Object)"org.apache.gravitino.meta.RoleEntity", (Object)"org.apache.gravitino.proto.RoleEntitySerDe").build();
    private static final Map<String, String> ENTITY_TO_PROTO = ImmutableMap.of((Object)"org.apache.gravitino.meta.AuditInfo", (Object)"org.apache.gravitino.proto.AuditInfo", (Object)"org.apache.gravitino.meta.BaseMetalake", (Object)"org.apache.gravitino.proto.Metalake", (Object)"org.apache.gravitino.meta.CatalogEntity", (Object)"org.apache.gravitino.proto.Catalog", (Object)"org.apache.gravitino.meta.SchemaEntity", (Object)"org.apache.gravitino.proto.Schema", (Object)"org.apache.gravitino.meta.TableEntity", (Object)"org.apache.gravitino.proto.Table", (Object)"org.apache.gravitino.meta.FilesetEntity", (Object)"org.apache.gravitino.proto.Fileset", (Object)"org.apache.gravitino.meta.TopicEntity", (Object)"org.apache.gravitino.proto.Topic", (Object)"org.apache.gravitino.meta.UserEntity", (Object)"org.apache.gravitino.proto.User", (Object)"org.apache.gravitino.meta.GroupEntity", (Object)"org.apache.gravitino.proto.Group", (Object)"org.apache.gravitino.meta.RoleEntity", (Object)"org.apache.gravitino.proto.Role");
    private final Map<Class<? extends Entity>, ProtoSerDe<? extends Entity, ? extends Message>> entityToSerDe = Maps.newConcurrentMap();
    private final Map<Class<? extends Entity>, Class<? extends Message>> entityToProto = Maps.newConcurrentMap();

    @Override
    public <T extends Entity> byte[] serialize(T t) throws IOException {
        Any any = Any.pack(this.toProto(t, Thread.currentThread().getContextClassLoader()));
        return any.toByteArray();
    }

    @Override
    public <T extends Entity> T deserialize(byte[] bytes, Class<T> clazz, ClassLoader classLoader, Namespace namespace) throws IOException {
        Class<? extends Message> protoClass;
        Any any = Any.parseFrom((byte[])bytes);
        if (!any.is(protoClass = this.getProtoClass(clazz, classLoader))) {
            throw new IOException("Invalid proto for entity " + clazz.getName());
        }
        Message anyMessage = any.unpack(protoClass);
        return this.fromProto(anyMessage, clazz, classLoader, namespace);
    }

    private <T extends Entity, M extends Message> ProtoSerDe<T, M> getProtoSerde(Class<T> entityClass, ClassLoader classLoader) throws IOException {
        if (!ENTITY_TO_SERDE.containsKey(entityClass.getCanonicalName()) || ENTITY_TO_SERDE.get(entityClass.getCanonicalName()) == null) {
            throw new IOException("No serde found for entity " + entityClass.getCanonicalName());
        }
        return this.entityToSerDe.computeIfAbsent(entityClass, k -> {
            try {
                Class<?> serdeClazz = this.loadClass(ENTITY_TO_SERDE.get(k.getCanonicalName()), classLoader);
                return (ProtoSerDe)serdeClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to instantiate serde class " + k.getCanonicalName(), e);
            }
        });
    }

    private Class<? extends Message> getProtoClass(Class<? extends Entity> entityClass, ClassLoader classLoader) throws IOException {
        if (!ENTITY_TO_PROTO.containsKey(entityClass.getCanonicalName()) || ENTITY_TO_PROTO.get(entityClass.getCanonicalName()) == null) {
            throw new IOException("No proto class found for entity " + entityClass.getCanonicalName());
        }
        return this.entityToProto.computeIfAbsent(entityClass, k -> {
            try {
                return this.loadClass(ENTITY_TO_PROTO.get(k.getCanonicalName()), classLoader);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create proto class " + k.getCanonicalName(), e);
            }
        });
    }

    private <T extends Entity, M extends Message> M toProto(T t, ClassLoader classLoader) throws IOException {
        ProtoSerDe<?, M> protoSerDe = this.getProtoSerde(t.getClass(), classLoader);
        return protoSerDe.serialize(t);
    }

    private <T extends Entity, M extends Message> T fromProto(M m, Class<T> entityClass, ClassLoader classLoader, Namespace namespace) throws IOException {
        ProtoSerDe<T, M> protoSerDe = this.getProtoSerde(entityClass, classLoader);
        return (T)((Entity)protoSerDe.deserialize(m, namespace));
    }

    private Class<?> loadClass(String className, ClassLoader classLoader) throws IOException {
        try {
            return Class.forName(className, true, classLoader);
        }
        catch (Exception e) {
            throw new IOException("Failed to load class " + className + " with classLoader " + classLoader, e);
        }
    }
}

