/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.hook;

import java.util.Map;
import org.apache.gravitino.Entity;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.authorization.Owner;
import org.apache.gravitino.authorization.OwnerManager;
import org.apache.gravitino.catalog.TopicDispatcher;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTopicException;
import org.apache.gravitino.exceptions.TopicAlreadyExistsException;
import org.apache.gravitino.messaging.DataLayout;
import org.apache.gravitino.messaging.Topic;
import org.apache.gravitino.messaging.TopicChange;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.PrincipalUtils;

public class TopicHookDispatcher
implements TopicDispatcher {
    private final TopicDispatcher dispatcher;

    public TopicHookDispatcher(TopicDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public NameIdentifier[] listTopics(Namespace namespace) throws NoSuchSchemaException {
        return this.dispatcher.listTopics(namespace);
    }

    public Topic loadTopic(NameIdentifier ident) throws NoSuchTopicException {
        return this.dispatcher.loadTopic(ident);
    }

    public Topic createTopic(NameIdentifier ident, String comment, DataLayout dataLayout, Map<String, String> properties) throws NoSuchSchemaException, TopicAlreadyExistsException {
        Topic topic = this.dispatcher.createTopic(ident, comment, dataLayout, properties);
        OwnerManager ownerManager = GravitinoEnv.getInstance().ownerManager();
        if (ownerManager != null) {
            ownerManager.setOwner(ident.namespace().level(0), NameIdentifierUtil.toMetadataObject(ident, Entity.EntityType.TOPIC), PrincipalUtils.getCurrentUserName(), Owner.Type.USER);
        }
        return topic;
    }

    public Topic alterTopic(NameIdentifier ident, TopicChange ... changes) throws NoSuchTopicException, IllegalArgumentException {
        return this.dispatcher.alterTopic(ident, changes);
    }

    public boolean dropTopic(NameIdentifier ident) {
        return this.dispatcher.dropTopic(ident);
    }

    public boolean topicExists(NameIdentifier ident) {
        return this.dispatcher.topicExists(ident);
    }
}

