/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.gravitino.Audit;
import org.apache.gravitino.Schema;
import org.apache.gravitino.StringIdentifier;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.SchemaEntity;

public final class EntityCombinedSchema
implements Schema {
    private final Schema schema;
    private final SchemaEntity schemaEntity;
    private Set<String> hiddenProperties;
    private boolean imported;

    private EntityCombinedSchema(Schema schema, SchemaEntity schemaEntity) {
        this.schema = schema;
        this.schemaEntity = schemaEntity;
        this.imported = false;
    }

    public static EntityCombinedSchema of(Schema schema, SchemaEntity schemaEntity) {
        return new EntityCombinedSchema(schema, schemaEntity);
    }

    public static EntityCombinedSchema of(Schema schema) {
        return EntityCombinedSchema.of(schema, null);
    }

    public EntityCombinedSchema withHiddenPropertiesSet(Set<String> hiddenProperties) {
        this.hiddenProperties = hiddenProperties;
        return this;
    }

    public EntityCombinedSchema withImported(boolean imported) {
        this.imported = imported;
        return this;
    }

    public String name() {
        return this.schema.name();
    }

    public String comment() {
        return this.schema.comment();
    }

    public Map<String, String> properties() {
        return this.schema.properties().entrySet().stream().filter(e -> !this.hiddenProperties.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Audit auditInfo() {
        AuditInfo mergedAudit = AuditInfo.builder().withCreator(this.schema.auditInfo().creator()).withCreateTime(this.schema.auditInfo().createTime()).withLastModifier(this.schema.auditInfo().lastModifier()).withLastModifiedTime(this.schema.auditInfo().lastModifiedTime()).build();
        return this.schemaEntity == null ? this.schema.auditInfo() : mergedAudit.merge(this.schemaEntity.auditInfo(), true);
    }

    public boolean imported() {
        return this.imported;
    }

    StringIdentifier stringIdentifier() {
        return StringIdentifier.fromProperties(this.schema.properties());
    }
}

